/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimation;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.AttackEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.AngerPoint;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.KeenEye;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.LongReach;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Merciless;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MindsEye;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overcoat;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ParentalBond;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Sniper;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SuperLuck;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Unaware;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.SkyBattleClause;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.ZMove;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.AttackModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.CriticalHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.MultipleHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Assurance;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BeatUp;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Drain;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Fling;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.FreezeDry;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.IgnoreDefense;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.PopulationBomb;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TripleAxel;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TripleKick;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnCharge;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Event;

public class Attack {
    public static final float EFFECTIVE_NORMAL = 1.0f;
    public static final float EFFECTIVE_SUPER = 2.0f;
    public static final float EFFECTIVE_MAX = 4.0f;
    public static final float EFFECTIVE_NOT = 0.5f;
    public static final float EFFECTIVE_BARELY = 0.25f;
    public static final float EFFECTIVE_NONE = 0.0f;
    public static final int ATTACK_PHYSICAL = 0;
    public static final int ATTACK_SPECIAL = 1;
    public static final int ATTACK_STATUS = 2;
    public static final int NEVER_MISS = -1;
    public static final int IGNORE_SEMIINVULNERABLE = -2;
    private ImmutableAttack baseAttack;
    private ImmutableAttack overrideAttack = null;
    public int pp;
    public int ppLevel;
    public int movePower;
    public int overridePower = -1;
    public int moveAccuracy;
    public boolean cantMiss;
    private boolean disabled;
    public MoveResults moveResult;
    public float damageResult;
    public boolean didCrit = false;
    public ImmutableAttack savedAttack;
    public int savedPower;
    public int savedAccuracy;
    private Integer overridePPMax = null;
    private AttackCategory overrideAttackCategory = null;
    private Element overrideType = null;
    public transient boolean hasPlayedAnimationOnce = false;
    public transient boolean isZ = false;
    public transient boolean isMax = false;
    public transient Attack originalMove = null;
    public transient boolean fromDancer = false;

    public Attack(ImmutableAttack base) {
        this.initializeAttack(base);
    }

    public Attack(String moveName) {
        AttackRegistry.getAttackBase(moveName).ifPresent(this::initializeAttack);
        if (this.getMove() == null) {
            Pixelmon.LOGGER.error("No attack found with name: " + moveName);
        }
    }

    public Attack(Optional<ImmutableAttack> move) {
        if (!move.isPresent()) {
            Pixelmon.LOGGER.error("Empty attack provided");
            return;
        }
        this.initializeAttack(move.get());
    }

    public void initializeAttack(ImmutableAttack base) {
        this.baseAttack = base;
        this.movePower = this.getMove().getBasePower();
        this.pp = this.getMove().getPPBase();
    }

    public ImmutableAttack getMove() {
        if (this.overrideAttack != null) {
            return this.overrideAttack;
        }
        if (this.baseAttack != null) {
            return this.baseAttack;
        }
        return this.originalMove.getMove();
    }

    public ImmutableAttack getActualMove() {
        return this.baseAttack;
    }

    public int getMaxPP() {
        return this.overridePPMax != null ? this.overridePPMax : this.getMove().getPPBase() + (int)((double)this.getMove().getPPBase() * 0.2 * (double)this.ppLevel);
    }

    public void overridePPMax(int pp) {
        this.overridePPMax = pp == -1 ? null : Integer.valueOf(pp);
    }

    public Integer getOverriddenPPMax() {
        return this.overridePPMax;
    }

    public AttackCategory getAttackCategory() {
        if (this.overrideAttackCategory != null) {
            return this.overrideAttackCategory;
        }
        if (this.overrideAttack != null) {
            return this.overrideAttack.getAttackCategory();
        }
        if (this.getMove().getAttackCategory() != null) {
            return this.getMove().getAttackCategory();
        }
        return this.originalMove.getAttackCategory();
    }

    public void overrideAttackCategory(AttackCategory category) {
        this.overrideAttackCategory = category;
    }

    public Element getType() {
        return this.overrideType != null ? this.overrideType : this.getActualType();
    }

    public Element getActualType() {
        return this.getMove().getAttackType();
    }

    public void overrideType(Element type) {
        this.overrideType = type;
    }

    public void resetMove() {
        this.overrideAttack = null;
        this.overrideType(null);
        this.overrideAttackCategory(null);
    }

    public void resetOverridePower() {
        this.overridePower = -1;
    }

    public boolean use(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults) {
        return this.use(user, target, moveResults, null);
    }

    public boolean use(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults, ZMove zMove) {
        PlayerPartyStorage pps2;
        AttackEvent.Use event;
        boolean z = zMove != null;
        this.setZMoveSettings(user, zMove);
        this.moveResult = moveResults;
        this.damageResult = -1.0f;
        if (user.bc == null || target.bc == null) {
            return false;
        }
        Element type = user.getBattleAbility().modifyType(user, user.attack);
        if (type != null) {
            user.attack.overrideType(type);
        }
        if (!this.checkSkyBattle(user.bc)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            moveResults.result = AttackResult.failed;
            return false;
        }
        if (target.getParticipant() != null && target.getParticipant().onTargeted(user, this)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            moveResults.result = AttackResult.failed;
            return false;
        }
        Ability userAbility = user.getBattleAbility();
        Ability targetAbility = target.getBattleAbility();
        if (!this.canHit(user, target) && !this.canHitNoTarget()) {
            moveResults.result = AttackResult.notarget;
            return true;
        }
        ArrayList<EffectBase> effects = new ArrayList<EffectBase>(this.getMove().effects);
        boolean shouldNotLosePP = false;
        for (int i = 0; i < effects.size(); ++i) {
            EffectBase e = effects.get(i);
            if (!(e instanceof MultiTurnSpecialAttackBase)) continue;
            shouldNotLosePP = ((MultiTurnSpecialAttackBase)e).shouldNotLosePP(user);
        }
        boolean selfTargeted = this.useSelfTargetingMoves(user, target, moveResults);
        if (selfTargeted) {
            AttackEvent.Use event2 = new AttackEvent.Use(user.bc, user, target, this.getMove(), 100.0, this.cantMiss);
            Pixelmon.EVENT_BUS.post((Event)event2);
            return !shouldNotLosePP;
        }
        if (user.targets.size() == 1) {
            target = this.redirectAttackToNewTarget(user, target);
        }
        if (z && !zMove.attackName.equals(this.getMove().getAttackName()) && this.getAttackCategory() != AttackCategory.STATUS) {
            effects.clear();
            effects.addAll(zMove.effects);
        }
        for (EffectBase e : effects) {
            try {
                if (e.applyEffectStart(user, target) == AttackResult.proceed) continue;
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int livePower = this.getMove().getBasePower();
        if (z) {
            livePower = zMove.basePower;
        } else if (this.overridePower > -1) {
            livePower = this.overridePower;
        }
        int[] modifiedMoveStats = this.modifyMoveStats(user, target, userAbility, targetAbility, livePower);
        this.movePower = modifiedMoveStats[0];
        if (!user.inMultipleHit && this.moveAccuracy >= 0) {
            this.moveAccuracy = Math.min(modifiedMoveStats[1], 100);
        } else if (modifiedMoveStats[1] == -2) {
            this.moveAccuracy = -2;
        }
        this.cantMiss = false;
        if (user.entity != null && target.entity != null) {
            user.entity.func_70671_ap().func_75651_a((Entity)user.entity, 0.0f, 0.0f);
        }
        double accuracy = this.moveAccuracy;
        if (this.moveAccuracy >= 0) {
            accuracy = this.calculateMoveAccuracy(user, target, userAbility);
        }
        ArrayList<StatusBase> allStatuses = new ArrayList<StatusBase>(target.getStatuses());
        allStatuses.addAll(target.bc.globalStatusController.getGlobalStatuses().stream().collect(Collectors.toList()));
        for (StatusBase e : user.getStatuses()) {
            try {
                if (!e.stopsIncomingAttackUser(target, user)) continue;
                return !shouldNotLosePP;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error calculating stopsIncomingAttack for " + e.type.toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        for (StatusBase e : allStatuses) {
            try {
                if (!e.stopsIncomingAttack(target, user)) continue;
                this.onMiss(user, target, moveResults, e);
                return !shouldNotLosePP;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error calculating stopsIncomingAttack for " + e.type.toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        int returningPP = this.doesAttackMiss(user, target, moveResults, targetAbility, shouldNotLosePP);
        if (returningPP == 0) {
            event = new AttackEvent.Use(user.bc, user, target, this.getMove(), accuracy, this.cantMiss);
            Pixelmon.EVENT_BUS.post((Event)event);
            return true;
        }
        if (returningPP == 1) {
            event = new AttackEvent.Use(user.bc, user, target, this.getMove(), accuracy, this.cantMiss);
            Pixelmon.EVENT_BUS.post((Event)event);
            return false;
        }
        if (!user.getBattleAbility().allowsOutgoingAttack(user, target, this)) {
            this.onMiss(user, target, moveResults, targetAbility);
            return !shouldNotLosePP;
        }
        if (this.hasNoEffect(user, target)) {
            event = new AttackEvent.Use(user.bc, user, target, this.getMove(), accuracy, this.cantMiss);
            Pixelmon.EVENT_BUS.post((Event)event);
            this.onMiss(user, target, moveResults, Element.MYSTERY);
            return !shouldNotLosePP;
        }
        if (!shouldNotLosePP) {
            targetAbility.preProcessAttack(target, user, this);
            userAbility.preProcessAttackUser(user, target, this);
        }
        boolean bl = this.cantMiss = z && this.getAttackCategory() != AttackCategory.STATUS || this.cantMiss(user) || this.moveAccuracy < 0;
        if (user.bc.simulateMode) {
            this.moveResult.accuracy = this.moveAccuracy;
            accuracy = 100.0;
        }
        event = new AttackEvent.Use(user.bc, user, target, this.getMove(), accuracy, this.cantMiss);
        Pixelmon.EVENT_BUS.post((Event)event);
        accuracy = event.accuracy;
        this.cantMiss = event.cantMiss;
        if (this.cantMiss || RandomHelper.getRandomChance((int)accuracy)) {
            this.useAttackEffects(user, target, moveResults, effects, userAbility);
        } else {
            this.onMiss(user, target, moveResults, null);
        }
        user.getBattleAbility().postProcessAttackUserHitOrMiss(user, target, this);
        for (int i = 0; i < target.getStatusSize(); ++i) {
            int sizeBefore = target.getStatusSize();
            target.getStatus(i).onAttackEnd(target);
            if (sizeBefore <= target.getStatusSize()) continue;
            --i;
        }
        if (!user.bc.simulateMode) {
            EnumUpdateType[] updateTypes = new EnumUpdateType[]{EnumUpdateType.HP, EnumUpdateType.Moveset};
            if (user.getPlayerOwner() != null) {
                user.update(updateTypes);
            }
            if (target.getPlayerOwner() != null) {
                target.update(updateTypes);
            }
        }
        try {
            pps2 = StorageProxy.getParty(user.pokemon.getOwnerPlayer());
            pps2.getQuestData(true).receive("BATTLE_MOVE_USER", user.pokemon, target.pokemon, this, moveResults);
        }
        catch (Exception pps2) {
            // empty catch block
        }
        try {
            pps2 = StorageProxy.getParty(target.pokemon.getOwnerPlayer());
            pps2.getQuestData(true).receive("BATTLE_MOVE_TARGET", user.pokemon, target.pokemon, this, moveResults);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !shouldNotLosePP;
    }

    private void setZMoveSettings(PixelmonWrapper user, ZMove zMove) {
        if (zMove != null) {
            if (user.skipZConvert) {
                user.skipZConvert = false;
            } else {
                this.isZ = true;
                Optional<ImmutableAttack> opt = AttackRegistry.getAttackBase(zMove.attackName);
                if (opt.isPresent()) {
                    this.overrideAttack = opt.get();
                    if (this.overrideAttack.getAttackCategory() != AttackCategory.STATUS) {
                        this.overrideAttackCategory(this.getActualMove().getAttackCategory());
                    }
                }
            }
        } else {
            this.isZ = false;
        }
    }

    private boolean useSelfTargetingMoves(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults) {
        if (user == target) {
            for (PixelmonWrapper activePokemon : user.bc.getActiveUnfaintedPokemon()) {
                for (StatusBase status : activePokemon.getStatuses()) {
                    if (!status.stopsSelfStatusMove(activePokemon, user, this)) continue;
                    moveResults.result = AttackResult.failed;
                    return true;
                }
            }
            if (!user.bc.simulateMode) {
                for (AttackAnimation anim : this.getMove().animations) {
                    if (anim.usedOncePerTurn() && this.hasPlayedAnimationOnce || user != target && !(user.entity.func_70032_d((Entity)target.entity) < 20.0f)) continue;
                    user.bc.addAnimation(anim.instantiate(user, target, this));
                }
            }
            this.applySelfStatusMove(user, moveResults);
            return true;
        }
        return false;
    }

    private PixelmonWrapper redirectAttackToNewTarget(PixelmonWrapper user, PixelmonWrapper target) {
        ArrayList<PixelmonWrapper> opponents = user.bc.getOpponentPokemon(user.getParticipant());
        if (opponents.size() > 1) {
            for (PixelmonWrapper pw : opponents) {
                if (pw == target) continue;
                for (StatusBase status : pw.getStatuses()) {
                    if (!status.redirectAttack(user, pw, this)) continue;
                    target = pw;
                    break;
                }
                if (!pw.getBattleAbility().redirectAttack(user, pw, this)) continue;
                target = pw;
                break;
            }
        }
        return target;
    }

    private int[] modifyMoveStats(PixelmonWrapper user, PixelmonWrapper target, Ability userAbility, Ability targetAbility, int livePower) {
        int[] modifiedMoveStats = userAbility.modifyPowerAndAccuracyUser(livePower, this.getMove().getAccuracy(), user, target, this);
        for (PixelmonWrapper teammate : user.bc.getTeamPokemon(user)) {
            modifiedMoveStats = teammate.getBattleAbility().modifyPowerAndAccuracyTeammate(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
        }
        modifiedMoveStats = targetAbility.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
        int saveAccuracy = 0;
        if (modifiedMoveStats[1] < 0) {
            saveAccuracy = modifiedMoveStats[1];
        }
        modifiedMoveStats = user.getUsableHeldItem().modifyPowerAndAccuracyUser(modifiedMoveStats, user, target, this);
        modifiedMoveStats = target.getUsableHeldItem().modifyPowerAndAccuracyTarget(modifiedMoveStats, user, target, this);
        int beforeSize = user.getStatuses().size();
        for (int i = 0; i < beforeSize; ++i) {
            StatusBase statusBase = user.getStatus(i);
            modifiedMoveStats = statusBase.modifyPowerAndAccuracyUser(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
            if (user.getStatuses().size() != beforeSize) break;
        }
        for (StatusBase statusBase : target.getStatuses()) {
            modifiedMoveStats = statusBase.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
        }
        for (StatusBase statusBase : user.bc.globalStatusController.getGlobalStatuses()) {
            modifiedMoveStats = statusBase.modifyPowerAndAccuracyTarget(modifiedMoveStats[0], modifiedMoveStats[1], user, target, this);
        }
        if (saveAccuracy < 0 && modifiedMoveStats[1] >= 0) {
            modifiedMoveStats[1] = saveAccuracy;
        }
        return modifiedMoveStats;
    }

    private double calculateMoveAccuracy(PixelmonWrapper user, PixelmonWrapper target, Ability userAbility) {
        double combinedAccuracy;
        int evasion = target.getBattleStats().getEvasionStage();
        if (user.bc.globalStatusController.hasStatus(StatusType.Gravity)) {
            evasion = Math.max(-6, evasion - 2);
        }
        if (user.getBattleAbility() instanceof KeenEye || user.getBattleAbility() instanceof MindsEye || target.hasStatus(StatusType.Foresight)) {
            evasion = Math.min(0, evasion);
        }
        if (this.getMove().hasEffect(IgnoreDefense.class) || userAbility instanceof Unaware) {
            evasion = 0;
        }
        int accuracy = user.getBattleStats().getAccuracyStage();
        if (target.getBattleAbility() instanceof Unaware) {
            accuracy = 0;
        }
        if ((combinedAccuracy = (double)(accuracy - evasion)) > 6.0) {
            combinedAccuracy = 6.0;
        } else if (combinedAccuracy < -6.0) {
            combinedAccuracy = -6.0;
        }
        return (double)this.moveAccuracy * ((double)user.getBattleStats().GetAccOrEva(combinedAccuracy) / 100.0);
    }

    private int doesAttackMiss(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults, Ability targetAbility, boolean shouldNotLosePP) {
        boolean targetAbilityIsCause = true;
        boolean allowed = target.getBattleAbility(user).allowsIncomingAttack(target, user, this);
        if (allowed && !(allowed = target.getUsableHeldItem().allowsIncomingAttack(target, user, this))) {
            targetAbilityIsCause = false;
        }
        if (allowed) {
            for (PixelmonWrapper ally : target.bc.getTeamPokemon(target)) {
                if (ally.getBattleAbility().allowsIncomingAttackTeammate(ally, target, user, this)) continue;
                allowed = false;
                break;
            }
        }
        if (!allowed) {
            try {
                if (targetAbilityIsCause) {
                    this.onMiss(user, target, moveResults, targetAbility);
                } else {
                    this.onMiss(user, target, moveResults, (Object)target.getUsableHeldItem());
                }
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error calculating allowsIncomingAttack for attack " + this.getMove().getLocalizedName());
            }
        }
        if (!allowed) {
            if (!shouldNotLosePP) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private void useAttackEffects(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults, ArrayList<EffectBase> effects, Ability userAbility) {
        CriticalHit critModifier = null;
        AttackResult finalResult = AttackResult.proceed;
        AttackResult applyEffectResult = AttackResult.proceed;
        for (EffectBase e : effects) {
            try {
                block20: {
                    block18: {
                        block19: {
                            if (!(e instanceof AttackModifierBase)) break block18;
                            if (!(e instanceof CriticalHit)) break block19;
                            critModifier = (CriticalHit)e;
                            break block20;
                        }
                        applyEffectResult = ((AttackModifierBase)e).applyEffectDuring(user, target);
                        if (applyEffectResult == AttackResult.proceed) break block20;
                        finalResult = applyEffectResult;
                        break block20;
                    }
                    if (e instanceof SpecialAttackBase) {
                        applyEffectResult = ((SpecialAttackBase)e).applyEffectDuring(user, target);
                        if (applyEffectResult != AttackResult.proceed) {
                            finalResult = applyEffectResult;
                        }
                    } else if (e instanceof MultiTurnSpecialAttackBase && (applyEffectResult = ((MultiTurnSpecialAttackBase)e).applyEffectDuring(user, target)) != AttackResult.proceed) {
                        finalResult = applyEffectResult;
                        break;
                    }
                }
                if (finalResult == AttackResult.succeeded || finalResult == AttackResult.failed || finalResult == AttackResult.charging || finalResult == AttackResult.notarget) {
                    moveResults.result = finalResult;
                    continue;
                }
                if (finalResult != AttackResult.hit) continue;
                if (target.isAlive()) {
                    moveResults.result = AttackResult.hit;
                    continue;
                }
                moveResults.result = AttackResult.killed;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        if (moveResults.result.isSuccess() || moveResults.result == AttackResult.charging) {
            this.playAnimation(user, target);
        }
        if (applyEffectResult == AttackResult.proceed) {
            if (userAbility instanceof ParentalBond) {
                user.inMultipleHit = true;
                user.inParentalBond = true;
                for (EffectBase e : effects) {
                    if (e instanceof BeatUp || e instanceof Fling || e instanceof MultiTurnCharge || e instanceof MultipleHit || e instanceof TripleKick) {
                        user.inMultipleHit = false;
                        user.inParentalBond = false;
                        continue;
                    }
                    if (!(e instanceof Assurance)) continue;
                    this.setOverridePower(this.getMove().getBasePower() * 2);
                }
            }
            this.playAnimation(user, target);
            this.hasPlayedAnimationOnce = true;
            this.executeAttackEffects(user, target, moveResults, critModifier, 1.0f);
            if (user.inParentalBond && this.getAttackCategory() != AttackCategory.STATUS && target.isAlive() && user.isAlive() && user.targets.size() == 1) {
                for (EffectBase e : effects) {
                    if (!(e instanceof Assurance)) continue;
                    this.setOverridePower(this.getMove().getBasePower() * 2);
                }
                user.inMultipleHit = false;
                user.inParentalBond = false;
                this.executeAttackEffects(user, target, moveResults, critModifier, 0.25f);
                user.bc.sendToAll("multiplehit.times", user.getNickname(), 2);
            }
            user.inParentalBond = false;
            for (EffectBase e : effects) {
                if (!(e instanceof SpecialAttackBase)) continue;
                ((SpecialAttackBase)e).applyAfterEffect(user);
            }
            target.getBattleAbility().postProcessAttack(target, user, this);
            user.getBattleAbility().postProcessAttackUser(user, target, this);
            user.getHeldItem().postProcessAttackUser(user, target, this);
            for (PixelmonWrapper wrapper : user.bc.getActivePokemon()) {
                wrapper.getBattleAbility().postProcessAttackOther(wrapper, user, target, this);
            }
        }
    }

    public boolean hasNoEffect(PixelmonWrapper user, PixelmonWrapper target) {
        boolean hasNoEffect;
        boolean bl = hasNoEffect = this.getTypeEffectiveness(user, target) == 0.0 && (this.getAttackCategory() != AttackCategory.STATUS || this.isAttack(AttackRegistry.POISON_GAS, AttackRegistry.POISON_POWDER, AttackRegistry.THUNDER_WAVE, AttackRegistry.TOXIC));
        if (!hasNoEffect && target.hasType(Element.GRASS) && Overcoat.isPowderMove(this)) {
            hasNoEffect = true;
        }
        for (int o = 0; o < this.getMove().effects.size(); ++o) {
            if (!(this.getMove().effects.get(o) instanceof MultiTurnSpecialAttackBase) || !((MultiTurnSpecialAttackBase)this.getMove().effects.get(o)).ignoresType(user)) continue;
            hasNoEffect = false;
            break;
        }
        return hasNoEffect;
    }

    private void executeAttackEffects(PixelmonWrapper user, PixelmonWrapper target, MoveResults moveResults, EffectBase critModifier, float damageMultiplier) {
        double crit = Attack.calcCriticalHit(critModifier, user, target);
        int power = (int)((float)this.doDamageCalc(user, target, crit) * damageMultiplier);
        this.damageResult = power;
        if (this.getAttackCategory() == AttackCategory.STATUS) {
            power = 0;
        } else if (target.isAlive()) {
            if (crit > 1.0) {
                if (user.targets.size() > 1) {
                    user.bc.sendToAll("pixelmon.battletext.criticalhittarget", target.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.criticalhit", new Object[0]);
                }
            }
            this.damageResult = target.doBattleDamage(user, power, DamageTypeEnum.ATTACK);
            moveResults.result = target.isAlive() ? AttackResult.hit : AttackResult.killed;
        } else {
            this.damageResult = -1.0f;
            moveResults.result = AttackResult.notarget;
        }
        AttackResult tempResult = this.applyAttackEffect(user, target);
        if (tempResult != null) {
            moveResults.result = tempResult;
        }
        Attack.applyContactLate(user, target);
        if (this.canRemoveBerry()) {
            target.getUsableHeldItem().tookDamage(user, target, this.damageResult, DamageTypeEnum.ATTACK);
        }
    }

    public void playAnimation(PixelmonWrapper user, PixelmonWrapper target) {
        LivingEntity owner;
        if (user.bc.simulateMode || user.entity == null || target.entity == null) {
            return;
        }
        if (user.entity.func_226277_ct_() == 0.0 && user.entity.func_226278_cu_() == 0.0 && user.entity.func_226281_cx_() == 0.0 && (owner = user.getParticipant().getEntity()) != null) {
            user.entity.func_70012_b(owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_(), owner.field_70177_z, 0.0f);
        }
        if (!user.bc.simulateMode) {
            for (AttackAnimation anim : this.getMove().animations) {
                if (anim.usedOncePerTurn() && this.hasPlayedAnimationOnce) continue;
                user.bc.addAnimation(anim.instantiate(user, target, this));
            }
        }
    }

    public int doDamageCalc(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, double crit) {
        BattleStatsType defenseStat;
        BattleStatsType attackStat;
        if (this.movePower <= 0) {
            return 0;
        }
        Ability userAbility = userWrapper.getBattleAbility();
        double stab = 1.0;
        if (this.hasSTAB(userWrapper)) {
            stab = 1.5;
        }
        stab = userAbility.modifyStab(stab);
        AttackEvent.Stab stabEvent = new AttackEvent.Stab(userWrapper.bc, userWrapper, targetWrapper, stab);
        Pixelmon.EVENT_BUS.post((Event)stabEvent);
        stab = stabEvent.stabMultiplier;
        double type = this.getTypeEffectiveness(userWrapper, targetWrapper);
        double critical = crit;
        double modifier = stab * type * critical;
        double attack = 0.0;
        double defense = 0.0;
        double level = userWrapper.getPokemonLevelNum();
        if (this.getAttackCategory() == AttackCategory.SPECIAL) {
            attackStat = BattleStatsType.SPECIAL_ATTACK;
            defenseStat = this.isAttack(AttackRegistry.PSYSHOCK, AttackRegistry.PSYSTRIKE, AttackRegistry.SECRET_SWORD) && !this.isZ ? BattleStatsType.DEFENSE : BattleStatsType.SPECIAL_DEFENSE;
        } else {
            attackStat = BattleStatsType.ATTACK;
            defenseStat = BattleStatsType.DEFENSE;
        }
        attack = userWrapper.getBattleStats().getStatWithMod(attackStat);
        defense = targetWrapper.getBattleStats().getStatWithMod(defenseStat);
        if (crit > 1.0) {
            attack = Math.max((double)userWrapper.getBattleStats().getStatFromEnum(attackStat), attack);
            defense = Math.min((double)targetWrapper.getBattleStats().getStatFromEnum(defenseStat), defense);
        }
        if (this.getMove().hasEffect(IgnoreDefense.class) || userAbility instanceof Unaware) {
            defense = targetWrapper.getBattleStats().getStatFromEnum(defenseStat);
        }
        if (this.isAttack(AttackRegistry.BEAT_UP) || targetWrapper.getBattleAbility(userWrapper) instanceof Unaware) {
            attack = userWrapper.getBattleStats().getStatFromEnum(attackStat);
        }
        attack = targetWrapper.getBattleAbility(userWrapper).preProcessAttackStatBeforeDamageCalc(userWrapper, attack);
        double dmgRand = (double)RandomHelper.getRandomNumberBetween(85, 100) / 100.0;
        if (userWrapper.bc.simulateMode) {
            dmgRand = 1.0;
        }
        double damageBase = (2.0 * level / 5.0 + 2.0) * attack * (double)this.movePower * 0.02 / defense + 2.0;
        double damage = damageBase * modifier * dmgRand;
        damage = userWrapper.getUsableHeldItem().preProcessDamagingAttackUser(userWrapper, targetWrapper, this, damage);
        damage = targetWrapper.getUsableHeldItem().preProcessDamagingAttackTarget(userWrapper, targetWrapper, this, damage);
        if (userWrapper.targets.size() > 1) {
            damage *= 0.75;
        }
        AttackEvent.Damage damageEvent = new AttackEvent.Damage(userWrapper.bc, userWrapper, targetWrapper, damage);
        Pixelmon.EVENT_BUS.post((Event)damageEvent);
        damage = damageEvent.damage;
        if (damage < 1.0 && damage > 0.0 && this.movePower > 0) {
            damage = 1.0;
        }
        return (int)damage;
    }

    public void applySelfStatusMove(PixelmonWrapper user, MoveResults moveResults) {
        if (user.entity != null) {
            user.entity.func_70671_ap().func_75651_a((Entity)user.entity, 0.0f, 0.0f);
        }
        boolean modifiedSelfStats = false;
        for (int j = 0; j < this.getMove().effects.size(); ++j) {
            EffectBase e = this.getMove().effects.get(j);
            try {
                if (e instanceof StatsEffect) {
                    AttackResult statsResult = ((StatsEffect)e).applyStatEffect(user, user, this.getMove());
                    if (moveResults.result != AttackResult.succeeded) {
                        moveResults.result = statsResult;
                    }
                    modifiedSelfStats = true;
                    continue;
                }
                if (e instanceof SpecialAttackBase) {
                    if (e.applyEffectStart(user, user) != AttackResult.proceed) {
                        return;
                    }
                    this.moveResult.result = ((SpecialAttackBase)e).applyEffectDuring(user, user);
                    continue;
                }
                if (e instanceof MultiTurnSpecialAttackBase) {
                    this.moveResult.result = ((MultiTurnSpecialAttackBase)e).applyEffectDuring(user, user);
                    continue;
                }
                if (!(e instanceof StatusBase)) continue;
                e.applyEffect(user, user);
                continue;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        if (modifiedSelfStats) {
            user.getBattleStats().notifyActivePokemonOfStatChange();
        }
        if (!user.bc.simulateMode && user.getPlayerOwner() != null) {
            user.update(EnumUpdateType.HP);
            user.setTemporaryMoveset(user.temporaryMoveset);
        }
        if (moveResults.result == AttackResult.proceed) {
            moveResults.result = AttackResult.succeeded;
        }
        if (moveResults.result == AttackResult.succeeded) {
            user.getBattleAbility().postProcessAttackUser(user, user, this);
            user.getHeldItem().postProcessAttackUser(user, user, this);
            for (PixelmonWrapper wrapper : user.bc.getActivePokemon()) {
                wrapper.getBattleAbility().postProcessAttackOther(wrapper, user, user, this);
            }
        }
    }

    public AttackResult applyAttackEffect(PixelmonWrapper user, PixelmonWrapper target) {
        AttackResult returnResult = null;
        boolean modifiedSelfStats = false;
        boolean modifiedTargetStats = false;
        for (int j = 0; j < this.getMove().effects.size(); ++j) {
            EffectBase e = this.getMove().effects.get(j);
            try {
                if (e instanceof StatsEffect) {
                    StatsEffect statsEffect = (StatsEffect)e;
                    if (statsEffect.isUser) {
                        modifiedSelfStats = true;
                    } else {
                        modifiedTargetStats = true;
                    }
                    boolean abilityAllowsChange = target.getBattleAbility(user).allowsStatChange(target, user, statsEffect);
                    if (abilityAllowsChange) {
                        for (PixelmonWrapper ally : target.bc.getTeamPokemon(target)) {
                            if (ally.getBattleAbility().allowsStatChangeTeammate(ally, target, user, statsEffect)) continue;
                            abilityAllowsChange = false;
                            break;
                        }
                    }
                    if (!abilityAllowsChange) continue;
                    AttackResult statsResult = statsEffect.applyStatEffect(user, target, this.getMove());
                    if (returnResult == AttackResult.succeeded) continue;
                    returnResult = statsResult;
                    continue;
                }
                if (e instanceof StatusBase) {
                    boolean shouldApply = true;
                    for (int i = 0; i < target.getStatusSize(); ++i) {
                        StatusBase et = target.getStatus(i);
                        if (user != target || !et.stopsStatusChange(et.type, target, user)) continue;
                        shouldApply = false;
                        break;
                    }
                    if (!shouldApply) continue;
                    e.applyEffect(user, target);
                    continue;
                }
                e.applyEffect(user, target);
                continue;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in applyEffect for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        if (modifiedSelfStats) {
            user.getBattleStats().notifyActivePokemonOfStatChange();
        }
        if (modifiedTargetStats && user != target) {
            target.getBattleStats().notifyActivePokemonOfStatChange();
        }
        return returnResult;
    }

    public static void applyContact(PixelmonWrapper user, PixelmonWrapper target) {
        if (!target.hasStatus(StatusType.Substitute)) {
            user.getBattleAbility().applyEffectOnContactUser(user, target);
            if (user.getUsableHeldItem().getHeldItemType() == EnumHeldItems.protectivePads || user.getBattleAbility().isAbility((Class<? extends AbstractAbility>)LongReach.class)) {
                return;
            }
            target.getUsableHeldItem().applyEffectOnContact(user, target);
            target.getBattleAbility().applyEffectOnContactTarget(user, target);
        }
    }

    public static void applyContactLate(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack != null && user.attack.getMove().getMakesContact() && !target.hasStatus(StatusType.Substitute) && !user.getBattleAbility().isAbility((Class<? extends AbstractAbility>)LongReach.class)) {
            target.getBattleAbility().applyEffectOnContactTargetLate(user, target);
        }
    }

    public static void postProcessAttackAllHits(PixelmonWrapper user, PixelmonWrapper target, Attack attack, float power, DamageTypeEnum damageType, boolean onSubstitute) {
        if (!user.inParentalBond) {
            if (attack != null) {
                for (EffectBase effect : attack.getMove().effects) {
                    if (effect == null) continue;
                    effect.dealtDamage(user, target, attack, damageType);
                }
                if (!onSubstitute) {
                    target.getBattleAbility().tookDamageTargetAfterMove(user, target, attack, power);
                    target.getUsableHeldItem().postProcessDamagingAttackTarget(user, target, attack, power);
                }
                user.getUsableHeldItem().dealtDamage(user, target, attack, damageType);
            }
        } else if (attack.getMove().hasEffect(Drain.class)) {
            for (EffectBase effect : attack.getMove().effects) {
                if (effect == null) continue;
                effect.dealtDamage(user, target, attack, damageType);
            }
        }
    }

    public void onMiss(PixelmonWrapper user, PixelmonWrapper target, MoveResults results, Object cause) {
        try {
            for (EffectBase effect : this.getMove().effects) {
                if (!(effect instanceof MultiTurnSpecialAttackBase) || !((MultiTurnSpecialAttackBase)effect).isCharging(user, target)) continue;
                results.result = ((MultiTurnSpecialAttackBase)effect).applyEffectDuring(user, target);
                if (results.result != AttackResult.charging) continue;
                return;
            }
            if (cause instanceof StatusBase) {
                ((StatusBase)cause).stopsIncomingAttackMessage(target, user);
            } else if (cause instanceof AbstractAbility) {
                ((AbstractAbility)cause).allowsIncomingAttackMessage(target, user, this);
            } else if (cause instanceof HeldItem) {
                ((HeldItem)((Object)cause)).allowsIncomingAttackMessage(target, user, this);
            } else if (cause instanceof Element) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
            } else if (!this.isAttack(AttackRegistry.TRIPLE_AXEL) || this.didMultipleHitMoveNeverHit()) {
                user.bc.sendToAll("pixelmon.battletext.missedattack", target.getNickname());
                results.result = AttackResult.missed;
            }
            for (EffectBase effect : this.getMove().effects) {
                effect.applyMissEffect(user, target);
            }
            user.getUsableHeldItem().onMiss(user, target, this);
        }
        catch (Exception exc) {
            user.bc.battleLog.onCrash(exc, "Error in applyMissEffect for attack " + this.getMove().getTranslatedName());
        }
        if (results.result != AttackResult.missed) {
            results.result = AttackResult.failed;
        }
    }

    public boolean hasSTAB(PixelmonWrapper user) {
        return user.hasType(this.getType());
    }

    public void setDisabled(boolean value, PixelmonWrapper pixelmon) {
        this.setDisabled(value, pixelmon, false);
    }

    public void setDisabled(boolean value, PixelmonWrapper pixelmon, boolean switching) {
        this.disabled = value;
        if (pixelmon != null && pixelmon.getParticipant() instanceof PlayerParticipant) {
            pixelmon.setTemporaryMoveset(pixelmon.temporaryMoveset);
        }
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public boolean canUseMove() {
        return !this.getDisabled() && this.pp > 0;
    }

    public static double calcCriticalHit(EffectBase e, PixelmonWrapper user, PixelmonWrapper target) {
        if (target.getBattleAbility(user).preventsCriticalHits(user) || target.hasStatus(StatusType.LuckyChant)) {
            return 1.0;
        }
        int critStage = 1;
        critStage += user.getUsableHeldItem().adjustCritStage(user);
        Ability userAbility = user.getBattleAbility();
        if (userAbility instanceof SuperLuck) {
            ++critStage;
        }
        float percent = 0.0417f;
        if (e instanceof CriticalHit) {
            critStage += ((CriticalHit)e).stages;
        }
        if ((critStage += user.getBattleStats().getCritStage()) == 2) {
            percent = 0.125f;
        } else if (critStage == 3) {
            percent = 0.5f;
        } else if (critStage >= 4) {
            percent = 1.0f;
        }
        if (user.bc.simulateMode && percent < 1.0f && !Merciless.willApply(user, target, user.attack)) {
            percent = 0.0f;
        }
        percent = user.getBattleAbility().adjustCriticalHitChance(user, target, user.attack, percent);
        double crit = 1.0;
        if (RandomHelper.getRandomChance(percent)) {
            Ability targetAbility = target.getBattleAbility();
            if (targetAbility instanceof AngerPoint && !user.bc.simulateMode) {
                ((AngerPoint)targetAbility).wasCrit = true;
            }
            crit = 1.5;
            if (userAbility instanceof Sniper) {
                crit *= 1.5;
            }
            user.attack.didCrit = true;
        } else {
            user.attack.didCrit = false;
        }
        AttackEvent.CriticalHit critEvent = new AttackEvent.CriticalHit(user.bc, user, target, crit);
        Pixelmon.EVENT_BUS.post((Event)critEvent);
        return critEvent.critMultiplier;
    }

    public boolean canHit(PixelmonWrapper pixelmon1, PixelmonWrapper pixelmon2) {
        return pixelmon2 != null && !pixelmon2.isFainted();
    }

    public boolean doesPersist(PixelmonWrapper pw) {
        if (this.isAttack(AttackRegistry.FLY, AttackRegistry.BOUNCE)) {
            return pw.hasStatus(StatusType.Flying);
        }
        for (int i = 0; i < this.getMove().effects.size(); ++i) {
            EffectBase e = this.getMove().effects.get(i);
            try {
                if (e == null || !e.doesPersist(pw)) continue;
                return true;
            }
            catch (Exception exc) {
                pw.bc.battleLog.onCrash(exc, "Error in doesPersist for " + (e == null ? "" : e.getClass().toString()) + " for attack " + this.getMove().getLocalizedName());
            }
        }
        return pw.hasStatus(StatusType.Recharge);
    }

    public boolean cantMiss(PixelmonWrapper user) {
        if (this.cantMiss) {
            return true;
        }
        for (int i = 0; i < this.getMove().effects.size(); ++i) {
            EffectBase e = this.getMove().effects.get(i);
            try {
                if (e instanceof StatsEffect && this.getMove().getAttackCategory() != AttackCategory.STATUS && ((StatsEffect)e).isUser || !e.cantMiss(user)) continue;
                return true;
            }
            catch (Exception exc) {
                user.bc.battleLog.onCrash(exc, "Error in cantMiss for " + e.getClass().toString() + " for attack " + this.getMove().getLocalizedName());
            }
        }
        return false;
    }

    public void sendEffectiveChat(PixelmonWrapper user, PixelmonWrapper target) {
        String s = null;
        if (this.getAttackCategory() != AttackCategory.STATUS) {
            float effectiveness = (float)this.getTypeEffectiveness(user, target);
            if (effectiveness == 0.0f) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                return;
            }
            if (effectiveness == 0.5f || effectiveness == 0.25f) {
                s = "pixelmon.battletext.wasnoteffective";
            } else if (effectiveness == 2.0f || effectiveness == 4.0f) {
                s = "pixelmon.battletext.supereffective";
            }
            if (s != null) {
                if (user.targets.size() > 1) {
                    user.bc.sendToAll(s.concat("target"), target.getNickname());
                } else {
                    user.bc.sendToAll(s, new Object[0]);
                }
            }
        }
    }

    public static boolean dealsDamage(Attack attack) {
        return attack != null && (attack.getMove().getBasePower() > 0 || attack.isMax && !attack.getMove().isAttack(AttackRegistry.MAX_GUARD));
    }

    public static boolean hasMoreEffects(Attack attack, EffectBase effect) {
        if (attack != null && attack.getMove() != null && effect != null) {
            List<EffectBase> effects = attack.getMove().effects;
            int currentIndex = effects.indexOf(effect);
            return currentIndex != -1 && currentIndex < effects.size() - 1;
        }
        return false;
    }

    public void saveAttack() {
        this.savedPower = this.getMove().getBasePower();
        this.savedAccuracy = this.getMove().getAccuracy();
        this.savedAttack = this.getMove();
    }

    public void restoreAttack() {
        this.setOverridePower(this.savedPower);
        this.setMoveAccuracy(this.savedAccuracy);
        this.resetMove();
    }

    public boolean isAttack(ImmutableAttack ... attacks) {
        for (ImmutableAttack attack : attacks) {
            if (!Objects.equals(attack, this.baseAttack)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isAttack(Optional<ImmutableAttack> ... attacks) {
        for (Optional<ImmutableAttack> attack : attacks) {
            if (!attack.isPresent() || !Objects.equals(attack.get(), this.baseAttack)) continue;
            return true;
        }
        return false;
    }

    public final boolean isAttack(List<Supplier<ImmutableAttack>> attacks) {
        for (Supplier<ImmutableAttack> attack : attacks) {
            if (attack.get() == null || !Objects.equals(attack.get(), this.baseAttack)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean hasAttack(List<Attack> attackList, Optional<ImmutableAttack> ... attacks) {
        for (Attack attack : attackList) {
            if (attack == null || !attack.isAttack(attacks)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOffensiveAttackType(List<Attack> attackList, Element type) {
        for (Attack attack : attackList) {
            if (attack == null || attack.getType() != type || attack.getAttackCategory() == AttackCategory.STATUS) continue;
            return true;
        }
        return false;
    }

    public void createMoveChoices(PixelmonWrapper pw, List<MoveChoice> choices, boolean includeAllies) {
        ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
        TargetingInfo info = this.getMove().getTargetingInfo();
        if (info.hitsSelf) {
            targets.add(pw);
        }
        if (info.hitsAdjacentAlly && (includeAllies || info.hitsAll)) {
            targets.addAll(pw.bc.getTeamPokemonExcludeSelf(pw));
        }
        if (info.hitsAdjacentFoe) {
            targets.addAll(pw.bc.getOpponentPokemon(pw));
        }
        if (info.hitsAll) {
            choices.add(new MoveChoice(pw, this, targets));
        } else {
            for (PixelmonWrapper target : targets) {
                ArrayList<PixelmonWrapper> targetArray = new ArrayList<PixelmonWrapper>(1);
                targetArray.add(target);
                choices.add(new MoveChoice(pw, this, targetArray));
            }
        }
    }

    public ArrayList<MoveChoice> createMoveChoices(PixelmonWrapper pw, boolean includeAllies) {
        ArrayList<MoveChoice> choices = new ArrayList<MoveChoice>();
        this.createMoveChoices(pw, choices, includeAllies);
        return choices;
    }

    public ArrayList<Attack> createList() {
        ArrayList<Attack> list = new ArrayList<Attack>(1);
        list.add(this);
        return list;
    }

    public boolean equals(Object compare) {
        if (compare == null || !(compare instanceof Attack)) {
            return false;
        }
        if (this.getMove() == null) {
            return false;
        }
        return this.getMove().getAttackName().equalsIgnoreCase(((Attack)compare).getMove().getAttackName());
    }

    public int hashCode() {
        if (this.getMove() == null) {
            return 0;
        }
        return this.getMove().getAttackName().hashCode();
    }

    public double getTypeEffectiveness(PixelmonWrapper user, PixelmonWrapper target) {
        double effectiveness;
        List<Element> effectiveTypes = target.getEffectiveTypes(user, target);
        if (effectiveTypes.contains(Element.FLYING) && this.getMove().isAttack(AttackRegistry.THOUSAND_ARROWS)) {
            effectiveness = 1.0;
        } else {
            boolean inverse = user.bc.rules.hasClause(BattleClauseRegistry.INVERSE_BATTLE);
            effectiveness = Element.getTotalEffectiveness(effectiveTypes, this.getType(), inverse);
            for (StatusBase s : target.getStatuses()) {
                effectiveness = inverse ? effectiveness * (double)Element.inverseEffectiveness((float)s.modifyTypeEffectiveness(effectiveTypes, this.getType(), 1.0, user.bc)) : s.modifyTypeEffectiveness(effectiveTypes, this.getType(), effectiveness, user.bc);
            }
            for (EffectBase e : this.getMove().effects) {
                if (e == null) continue;
                if (e instanceof FreezeDry && target.type.contains(Element.WATER)) {
                    effectiveness = e.modifyTypeEffectiveness(effectiveTypes, this.getType(), effectiveness, user.bc);
                    continue;
                }
                effectiveness = inverse ? effectiveness * (double)Element.inverseEffectiveness((float)e.modifyTypeEffectiveness(effectiveTypes, this.getType(), 1.0, user.bc)) : e.modifyTypeEffectiveness(effectiveTypes, this.getType(), effectiveness, user.bc);
            }
        }
        AttackEvent.TypeEffectiveness event = new AttackEvent.TypeEffectiveness(user.bc, user, target, effectiveness);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.getMultiplier();
    }

    public boolean canRemoveBerry() {
        return this.isAttack(AttackRegistry.BUG_BITE, AttackRegistry.PLUCK, AttackRegistry.KNOCK_OFF);
    }

    public Attack copy() {
        Attack newAttack = new Attack(this.getMove());
        newAttack.pp = this.pp;
        newAttack.ppLevel = this.ppLevel;
        return newAttack;
    }

    public Attack deepCopy() {
        return new Attack(this);
    }

    public Attack(Attack attack) {
        this.baseAttack = attack.baseAttack;
        this.cantMiss = attack.cantMiss;
        this.damageResult = attack.damageResult;
        this.disabled = attack.disabled;
        this.fromDancer = attack.fromDancer;
        this.hasPlayedAnimationOnce = attack.hasPlayedAnimationOnce;
        this.isMax = attack.isMax;
        this.isZ = attack.isZ;
        this.moveAccuracy = attack.moveAccuracy;
        this.movePower = attack.movePower;
        this.moveResult = attack.moveResult;
        this.originalMove = attack.originalMove;
        this.overrideAttack = attack.overrideAttack;
        this.overrideAttackCategory = attack.overrideAttackCategory;
        this.overridePower = attack.overridePower;
        this.overridePPMax = attack.overridePPMax;
        this.overrideType = attack.overrideType;
        this.pp = attack.pp;
        this.ppLevel = attack.ppLevel;
        this.savedAccuracy = attack.savedAccuracy;
        this.savedAttack = attack.savedAttack;
        this.savedPower = attack.savedPower;
    }

    public boolean checkSkyBattle(BattleController bc) {
        return !bc.rules.hasClause(BattleClauseRegistry.SKY_BATTLE) || SkyBattleClause.isMoveAllowed(this);
    }

    public boolean canHitNoTarget() {
        return this.isAttack(AttackRegistry.DOOM_DESIRE, AttackRegistry.FUTURE_SIGHT, AttackRegistry.IMPRISON, AttackRegistry.STEALTH_ROCK, AttackRegistry.STICKY_WEB, AttackRegistry.TOXIC_SPIKES);
    }

    public boolean isSoundBased() {
        return this.getMove().getFlags().sound;
    }

    public static boolean hasAttack(String moveName) {
        return AttackRegistry.getAttackBase(moveName).isPresent() && AttackRegistry.getAttackBase(moveName).get().getAttackName() != null;
    }

    public static ImmutableAttack[] getAttacks(String[] nameList) {
        ImmutableAttack[] attacks = new ImmutableAttack[nameList.length];
        for (int i = 0; i < nameList.length; ++i) {
            attacks[i] = AttackRegistry.getAttackBase(nameList[i].toLowerCase(Locale.ROOT)).orElse(null);
            if (attacks[i] != null) continue;
            Pixelmon.LOGGER.error("No attack found with name: " + nameList[i]);
        }
        return attacks;
    }

    public void setOverridePower(int overridePower) {
        this.overridePower = overridePower;
    }

    public int getOverridePower() {
        return this.overridePower;
    }

    public void setMoveAccuracy(int moveAccuracy) {
        this.moveAccuracy = moveAccuracy;
    }

    private boolean didMultipleHitMoveNeverHit() {
        for (EffectBase effect : this.getMove().effects) {
            PopulationBomb populationBomb;
            TripleAxel tripleAxel;
            if (effect instanceof TripleAxel && (tripleAxel = (TripleAxel)effect).getCount() <= 1) {
                return true;
            }
            if (!(effect instanceof PopulationBomb) || (populationBomb = (PopulationBomb)effect).getCount() > 1) continue;
            return true;
        }
        return false;
    }

    public boolean ignoresWeather(PixelmonWrapper pw) {
        for (EffectBase effect : this.getMove().effects) {
            if (!(effect instanceof SpecialAttackBase) || !((SpecialAttackBase)effect).ignoresWeather(pw)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.baseAttack.getAttackName()).append("[");
        if (this.overrideAttack != null) {
            builder.append("override attack: ").append(this.overrideAttack.getAttackName()).append(", ");
        }
        builder.append("pp ").append(this.pp).append(", ");
        builder.append("ppLevel ").append(this.ppLevel).append(", ");
        builder.append("movePower ").append(this.movePower).append(", ");
        if (this.overridePower != -1) {
            builder.append("overridePower ").append(this.overridePower).append(", ");
        }
        builder.append("moveAccuracy ").append(this.moveAccuracy).append(", ");
        builder.append("cantMiss ").append(this.cantMiss).append(", ");
        builder.append("disabled ").append(this.disabled).append(", ");
        if (this.moveResult != null) {
            builder.append("moveResult ").append(this.moveResult).append(", ");
            builder.append("damageResult ").append(this.damageResult).append(", ");
            builder.append("didCrit ").append(this.didCrit).append(", ");
        }
        builder.append("savedAttack ").append(this.savedAttack).append(", ");
        builder.append("savedPower ").append(this.savedPower).append(", ");
        builder.append("savedAccuracy ").append(this.savedAccuracy).append(", ");
        builder.append("overridePPMax ").append(this.overridePPMax).append(", ");
        builder.append("overrideAttackCategory ").append((Object)this.overrideAttackCategory).append(", ");
        builder.append("overrideType ").append(this.overrideType).append(", ");
        builder.append("isZ ").append(this.isZ).append(", ");
        builder.append("isMax ").append(this.isMax).append(", ");
        builder.append("originalMove ").append(this.originalMove);
        return builder.append("]").toString();
    }
}

