/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class RCFileHelper {
    public static String encodePath(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return path;
        }
    }

    static Path resourceToPath(URL resource) throws IOException, URISyntaxException {
        return null;
    }

    public static Path pathFromResourceLocation(ResourceLocation resourceLocation) throws URISyntaxException, IOException {
        URL resource = RCFileHelper.class.getResource(String.format("/assets/%s/%s", resourceLocation.func_110624_b(), resourceLocation.func_110623_a()));
        return resource != null ? RCFileHelper.resourceToPath(resource.toURI().toURL()) : null;
    }

    public static List<Path> listFilesRecursively(Path dir, final DirectoryStream.Filter<Path> filter, final boolean recursive) throws IOException {
        final ArrayList<Path> files = new ArrayList<Path>();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (filter.accept(file)) {
                    files.add(file);
                }
                return recursive ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }
        });
        return files;
    }

    public static void recursiveJSONSearch(String dir, ArrayList<File> jsons) {
        File file = new File(dir);
        for (String name : file.list()) {
            File subFile = new File(dir + "/" + name);
            if (subFile.isFile() && name.endsWith(".json")) {
                jsons.add(subFile);
                continue;
            }
            if (!subFile.isDirectory()) continue;
            RCFileHelper.recursiveJSONSearch(dir + "/" + name, jsons);
        }
    }

    public static File getValidatedFolder(File file, boolean create) {
        if (create && !file.exists() && !file.mkdir()) {
            System.out.println("Could not create " + file.getName() + " folder");
        }
        return file.exists() ? file : null;
    }

    public static File getValidatedFolder(File parent, String child, boolean create) {
        return RCFileHelper.getValidatedFolder(new File(parent, child), create);
    }
}

