/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.data.PixelmonPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class NetworkHelper {
    public static void sendPacket(PixelmonPacket packet, ServerPlayerEntity serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        Pixelmon.network.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        if (Pixelmon.LOG_PACKETS) {
            Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendPacket(ServerPlayerEntity serverPlayer, PixelmonPacket packet) {
        Pixelmon.network.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        if (Pixelmon.LOG_PACKETS) {
            Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(PixelmonPacket packet, PacketDistributor.TargetPoint targetPoint) {
        Pixelmon.network.send(PacketDistributor.NEAR.with(() -> targetPoint), packet);
        if (Pixelmon.LOG_PACKETS) {
            Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendNearbyPacket(PacketDistributor.TargetPoint targetPoint, PixelmonPacket packet) {
        Pixelmon.network.send(PacketDistributor.NEAR.with(() -> targetPoint), packet);
        if (Pixelmon.LOG_PACKETS) {
            Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToDimension(PixelmonPacket packet, World world) {
        Pixelmon.network.send(PacketDistributor.DIMENSION.with(() -> ((World)world).func_234923_W_()), packet);
        if (Pixelmon.LOG_PACKETS) {
            Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToAllTracking(PixelmonPacket packet, Entity entity) {
        Pixelmon.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), packet);
        if (Pixelmon.LOG_PACKETS) {
            Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToAll(PixelmonPacket packet) {
        Pixelmon.network.send(PacketDistributor.ALL.with(() -> null), packet);
        if (Pixelmon.LOG_PACKETS) {
            Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
        }
    }

    public static void sendToServer(PixelmonPacket packet) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Pixelmon.network.sendToServer(packet);
            if (Pixelmon.LOG_PACKETS) {
                Pixelmon.LOGGER.info("Packet sent: " + packet.getClass().getSimpleName());
            }
        }
    }
}

