/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.util.IEncodeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ArrayHelper {
    public static <T> int indexOf(T[] array, T object) {
        if (array == null || object == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (!Objects.equals(t, object)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value && (array[i] == null || value == null || !array[i].equals(value))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean arrayHasNull(T[] array) {
        if (array == null || array.length == 0) {
            return true;
        }
        for (T object : array) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    public static <T> void validateArrayNonNull(T[] array) {
        if (ArrayHelper.arrayHasNull(array)) {
            throw new IllegalArgumentException("Array cannot have null elements.");
        }
    }

    public static void encodeArray(PacketBuffer buffer, IEncodeable[] array) {
        if (array == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(array.length);
        for (IEncodeable encodeable : array) {
            encodeable.encodeInto(buffer);
        }
    }

    public static void encodeList(PacketBuffer buffer, List<? extends IEncodeable> list) {
        if (list == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(list.size());
        for (IEncodeable iEncodeable : list) {
            iEncodeable.encodeInto(buffer);
        }
    }

    public static void encodeStringList(PacketBuffer buffer, List<String> list) {
        if (list == null) {
            buffer.writeInt(0);
            return;
        }
        ArrayHelper.encodeStringArray(buffer, list.toArray(new String[list.size()]));
    }

    public static void encodeStringArray(PacketBuffer buffer, String[] array) {
        if (array == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(array.length);
        for (String string : array) {
            if (string == null) {
                string = "";
            }
            buffer.func_180714_a(string);
        }
    }

    public static List<String> decodeStringList(PacketBuffer buffer) {
        ArrayList<String> list = new ArrayList<String>();
        int listLength = buffer.readInt();
        for (int i = 0; i < listLength; ++i) {
            list.add(buffer.func_218666_n());
        }
        return list;
    }

    public static String[] decodeStringArray(PacketBuffer buffer) {
        String[] array = new String[buffer.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buffer.func_218666_n();
        }
        return array;
    }

    public static boolean[][] deepCopy(boolean[][] array) {
        int i;
        boolean[][] copy = new boolean[array.length][];
        for (i = 0; i < array.length; ++i) {
            copy[i] = new boolean[array[i].length];
        }
        for (i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, copy[i], 0, array[i].length);
        }
        return copy;
    }

    public static <T> T[][] deepCopy(T[][] array) {
        int i;
        Object[][] copy = new Object[array.length][];
        for (i = 0; i < array.length; ++i) {
            copy[i] = new Object[array[i].length];
        }
        for (i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, copy[i], 0, array[i].length);
        }
        return copy;
    }

    public static <T> T[][][] deepCopy(T[][][] array) {
        Object[][][] copy = new Object[array.length][][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = ArrayHelper.deepCopy(array[i]);
        }
        return copy;
    }

    public static String[] addStringAtIndex(String[] array, int indexToAddAt, String value) {
        String[] newarr = new String[array.length + 1];
        for (int i = 0; i < array.length + 1; ++i) {
            newarr[i] = i < indexToAddAt ? array[i] : (i == indexToAddAt ? value : array[i - 1]);
        }
        return newarr;
    }

    public static IFormattableTextComponent join(IFormattableTextComponent delimiter, IFormattableTextComponent ... texts) {
        StringTextComponent result = new StringTextComponent("");
        for (int i = 0; i < texts.length; ++i) {
            boolean isLast;
            result.func_230529_a_((ITextComponent)texts[i]);
            boolean bl = isLast = i == texts.length - 1;
            if (isLast) continue;
            result.func_230529_a_((ITextComponent)delimiter);
        }
        return result;
    }

    public static String concat(int start, String divider, String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < strings.length; ++i) {
            if (builder.length() > 0) {
                builder.append(divider);
            }
            builder.append(strings[i]);
        }
        return builder.toString();
    }
}

