/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.ai.AvoidEntitiesGoal;
import com.pixelmonmod.pixelmon.ai.ExecuteActionGoal;
import com.pixelmonmod.pixelmon.ai.FlyingGoal;
import com.pixelmonmod.pixelmon.ai.FlyingPersistentGoal;
import com.pixelmonmod.pixelmon.ai.FollowTrainerGoal;
import com.pixelmonmod.pixelmon.ai.MoveTowardsBlockGoal;
import com.pixelmonmod.pixelmon.ai.MoveTowardsTargetGoal;
import com.pixelmonmod.pixelmon.ai.StareDownGoal;
import com.pixelmonmod.pixelmon.ai.SwimmingGoal;
import com.pixelmonmod.pixelmon.ai.TargetNearestGoal;
import com.pixelmonmod.pixelmon.ai.TeleportAwayGoal;
import com.pixelmonmod.pixelmon.ai.TemptGoal;
import com.pixelmonmod.pixelmon.ai.WanderGoal;
import com.pixelmonmod.pixelmon.ai.naivgator.PixelmonGroundPathNavigator;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractInteractionsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;

public class AIHelper {
    int i = 0;

    public void populateTasks(AbstractInteractionsEntity entity, GoalSelector tasks) {
        tasks.field_220892_d.clear();
        PixelmonEntity pixelmon = (PixelmonEntity)entity;
        this.initBaseAI(pixelmon, tasks);
        if (!(pixelmon.getSpawnLocation() != SpawnLocationType.LAND || entity.getForm().getMovement().canFly() || entity.getForm().getMovement().isRideable() && entity.getForm().getTypes().contains(Element.WATER))) {
            this.initGroundAI(pixelmon, tasks);
        } else if (entity.getForm().getMovement().canFly() && entity.getFlyingParameters() != null) {
            if (pixelmon.getSpawnLocation() == SpawnLocationType.AIR_PERSISTENT) {
                this.initFlyingPersistentAI(pixelmon, tasks);
            } else {
                this.initFlyingAI(pixelmon, tasks);
            }
        } else if (pixelmon.getSpawnLocation() == SpawnLocationType.WATER) {
            this.initSwimmingAI(pixelmon, tasks);
        } else {
            this.initGroundAI(pixelmon, tasks);
        }
    }

    public PathNavigator createNavigator(AbstractInteractionsEntity pixelmon) {
        if (!(pixelmon.getSpawnLocation() != SpawnLocationType.LAND || pixelmon.getForm().getMovement().canFly() || pixelmon.getForm().getMovement().isRideable() && pixelmon.getForm().getTypes().contains(Element.WATER))) {
            return new PixelmonGroundPathNavigator((MobEntity)pixelmon, pixelmon.field_70170_p);
        }
        if (pixelmon.getForm().getMovement().canFly() && pixelmon.getFlyingParameters() != null) {
            if (pixelmon.getSpawnLocation() == SpawnLocationType.AIR_PERSISTENT) {
                return new FlyingPathNavigator((MobEntity)pixelmon, pixelmon.field_70170_p);
            }
            return new FlyingPathNavigator((MobEntity)pixelmon, pixelmon.field_70170_p);
        }
        if (pixelmon.getSpawnLocation() == SpawnLocationType.WATER) {
            return new SwimmerPathNavigator((MobEntity)pixelmon, pixelmon.field_70170_p);
        }
        return new PixelmonGroundPathNavigator((MobEntity)pixelmon, pixelmon.field_70170_p);
    }

    private void initBaseAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.func_75776_a(this.i++, (Goal)new StareDownGoal(pixelmon));
        tasks.func_75776_a(this.i++, (Goal)new ExecuteActionGoal((CreatureEntity)pixelmon));
        tasks.func_75776_a(this.i++, new AvoidEntitiesGoal<PlayerEntity>((CreatureEntity)pixelmon, PlayerEntity.class, 16.0f, 0.23f, 0.4f));
        tasks.func_75776_a(this.i++, (Goal)new MoveTowardsBlockGoal(pixelmon, 25.0f));
    }

    private void initFlyingPersistentAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.func_75776_a(this.i++, (Goal)new FollowTrainerGoal(pixelmon, 1.0, 10.0f, 4.0f, true));
        tasks.func_75776_a(this.i++, (Goal)new TemptGoal((CreatureEntity)pixelmon, false));
        tasks.func_75776_a(this.i++, (Goal)new FlyingPersistentGoal(pixelmon));
    }

    private void initSwimmingAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.func_75776_a(this.i++, (Goal)new FollowTrainerGoal(pixelmon, 1.0, 10.0f, 4.0f, true));
        tasks.func_75776_a(this.i++, (Goal)new TemptGoal((CreatureEntity)pixelmon, false));
        tasks.func_75776_a(this.i++, (Goal)new SwimmingGoal(pixelmon));
    }

    private void initFlyingAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.func_75776_a(this.i++, (Goal)new SwimGoal((MobEntity)pixelmon));
        tasks.func_75776_a(this.i++, (Goal)new FollowTrainerGoal(pixelmon, 1.0, 10.0f, 4.0f, true));
        tasks.func_75776_a(this.i++, (Goal)new TemptGoal((CreatureEntity)pixelmon, false));
        tasks.func_75776_a(this.i++, (Goal)new LookAtGoal((MobEntity)pixelmon, PixelmonEntity.class, 8.0f));
        tasks.func_75776_a(this.i++, (Goal)new FlyingGoal(pixelmon));
    }

    private void initGroundAI(PixelmonEntity entity, GoalSelector tasks) {
        if (entity.getForm().getTypes().contains(Element.FIRE)) {
            if (entity.func_70661_as() instanceof GroundPathNavigator) {
                entity.func_70661_as().func_212239_d(true);
            }
            if (entity.func_70661_as() instanceof FlyingPathNavigator) {
                entity.func_70661_as().func_212239_d(true);
            }
        }
        if (entity.getSpecies().is(PixelmonSpecies.ABRA)) {
            tasks.func_75776_a(this.i++, (Goal)new TeleportAwayGoal(entity));
        }
        tasks.func_75776_a(this.i++, (Goal)new MoveTowardsTargetGoal((MobEntity)entity, 1.005));
        tasks.func_75776_a(this.i++, (Goal)new TargetNearestGoal((CreatureEntity)entity, 8.0f, false));
        tasks.func_75776_a(this.i++, (Goal)new SwimGoal((MobEntity)entity));
        tasks.func_75776_a(this.i++, (Goal)new FollowTrainerGoal(entity, 1.0, 10.0f, 4.0f, false));
        tasks.func_75776_a(this.i++, (Goal)new TemptGoal((CreatureEntity)entity, false));
        tasks.func_75776_a(this.i++, (Goal)new WanderGoal((CreatureEntity)entity));
        tasks.func_75776_a(this.i++, (Goal)new LookAtGoal((MobEntity)entity, PixelmonEntity.class, 8.0f));
        tasks.func_75776_a(this.i++, (Goal)new LookRandomlyGoal((MobEntity)entity));
    }
}

