/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class WeightedSet<T> {
    private final TreeMap<Double, T> treeMap = new TreeMap();
    private final Map<T, Double> weightMap = new HashMap<T, Double>();
    private double maxWeight = 0.0;

    protected WeightedSet() {
    }

    public static <T> WeightedSet<T> newWeightedSet(Object ... contents) {
        WeightedSet<Object> set = new WeightedSet<Object>();
        if (contents.length % 2 == 0) {
            for (int i = 0; i < contents.length; i += 2) {
                set.add(((Integer)contents[i]).intValue(), contents[i + 1]);
            }
        }
        return set;
    }

    public WeightedSet<T> add(double weight, T element) {
        weight = Math.abs(weight);
        this.maxWeight += weight;
        this.treeMap.put(this.maxWeight, element);
        this.weightMap.put(element, weight);
        return this;
    }

    public WeightedSet<T> clear() {
        this.treeMap.clear();
        this.weightMap.clear();
        this.maxWeight = 0.0;
        return this;
    }

    public T get() {
        return this.get(RandomHelper.getRandom());
    }

    public T get(Random random) {
        if (this.isEffectivelyEmpty()) {
            return null;
        }
        return this.treeMap.get(this.treeMap.ceilingKey(random.nextDouble() * this.maxWeight));
    }

    public void getAndDo(int count, Consumer<T> consumer) {
        this.getAndDo(RandomHelper.getRandom(), count, consumer);
    }

    public void getAndDo(Random random, int count, Consumer<T> consumer) {
        for (int i = 0; i < count; ++i) {
            consumer.accept(this.get(random));
        }
    }

    public double getWeight(T element) {
        return this.weightMap.getOrDefault(element, 0.0);
    }

    public double getChance(T element) {
        return this.getWeight(element) / this.maxWeight;
    }

    public String getChanceString(T element, int decimalPlaces) {
        String value = String.format("%." + decimalPlaces + "f", this.getChance(element) * 100.0);
        while (value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.contains(".")) {
            while (value.endsWith("0")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    public boolean isEffectivelyEmpty() {
        return this.isEmpty() || this.maxWeight <= 0.0;
    }

    public boolean isEmpty() {
        return this.treeMap.isEmpty();
    }

    public int size() {
        return this.treeMap.size();
    }

    public double weight() {
        return this.maxWeight;
    }

    public Stream<T> stream() {
        return this.treeMap.values().stream();
    }

    public Iterator<T> iterator() {
        return this.treeMap.values().iterator();
    }

    public Spliterator<T> spliterator() {
        return this.treeMap.values().spliterator();
    }
}

