/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.lang.reflect.Type;

public class Range {
    private int minValue;
    private int maxValue;

    public static Range of(int minValue, int maxValue) {
        return new Range(minValue, maxValue);
    }

    private Range(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getRandomValue() {
        return RandomHelper.getRandomNumberBetween(this.minValue, this.maxValue);
    }

    public static final class TypeAdapter
    implements JsonSerializer<Range>,
    JsonDeserializer<Range> {
        public Range deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new Range(object.get("min_value").getAsInt(), object.get("max_value").getAsInt());
        }

        public JsonElement serialize(Range src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("min_value", (Number)src.minValue);
            object.addProperty("max_value", (Number)src.maxValue);
            return object;
        }
    }
}

