/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.concurrent.CompletableFuture;

public class ShedinjaHPDynamaxTest {
    private ShedinjaHPDynamaxTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @UnitTest(value="shedinja_hp_dynamax")
    public static CompletableFuture<TestResult> testShedinjaHPDynamax() {
        WildPixelmonParticipant shedinjaOne = ShedinjaHPDynamaxTest.createShedinja();
        WildPixelmonParticipant shedinjaTwo = ShedinjaHPDynamaxTest.createShedinja();
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(shedinjaOne).teamTwo(shedinjaTwo).start().thenCompose(controller -> {
            shedinjaOne.asWrapper().isDynamax = 1;
            shedinjaOne.asWrapper().dynamax(false, shedinjaOne.asWrapper().getHealthPercent());
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            if (shedinjaOne.asWrapper().isDynamax() && shedinjaOne.asWrapper().getMaxHealth() == 1) {
                return TestResult.success();
            }
            return TestResult.failure("Shedinja does not have 1 HP while Dynamaxed!");
        });
    }

    private static WildPixelmonParticipant createShedinja() {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.SHEDINJA.getValue()).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

