/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class HiddenPowerMaxMoveTypingTest {
    private HiddenPowerMaxMoveTypingTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @UnitTest(value="hidden_power_max_move_typing")
    public static CompletableFuture<TestResult> testMaxHiddenPowerHasCorrectTyping() {
        Attack hiddenPower = AttackRegistry.HIDDEN_POWER.get().ofMutable();
        WildPixelmonParticipant unown1 = HiddenPowerMaxMoveTypingTest.createUnownWithOnlyHiddenPower(hiddenPower);
        WildPixelmonParticipant unown2 = new WildPixelmonParticipant(PokemonBuilder.copy(unown1.asWrapper().pokemon).build());
        unown2.setBattleAI(new NoOpAI(unown2));
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Dynamax)).teamOne(unown1).teamTwo(unown2).start().thenCompose(controller -> {
            System.out.println("About to test Hidden Power typing.");
            unown1.asWrapper().setAttack(hiddenPower, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{unown2.asWrapper()}), false);
            unown1.asWrapper().takeTurn();
            unown2.asWrapper().setAttack(hiddenPower, (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{unown1.asWrapper()}), true);
            unown2.asWrapper().isDynamax = 1;
            unown2.asWrapper().dynamax(false, unown2.asWrapper().getHealthPercent());
            unown2.asWrapper().takeTurn();
            System.out.println("The attack Unown1 used: " + unown1.asWrapper().attack.toString());
            System.out.println("The attack type: " + unown1.asWrapper().attack.getType());
            System.out.println("Unown2 Dynamaxed? " + unown2.asWrapper().isDynamax());
            System.out.println("The attack Unown2 used: " + unown2.asWrapper().attack.toString());
            System.out.println("The attack type: " + unown2.asWrapper().attack.getType());
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            if (unown1.asWrapper().attack.getType() == unown2.asWrapper().attack.getType()) {
                return TestResult.success();
            }
            return TestResult.failure("The Max Hidden Power attack had the incorrect type.");
        });
    }

    private static WildPixelmonParticipant createUnownWithOnlyHiddenPower(Attack ... attacks) {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(PokemonBuilder.builder().species(PixelmonSpecies.UNOWN.getValue()).moves(attacks).build());
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

