/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.util;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawningHeightmap {
    private static final Map<String, Heightmap> SEES_SKY_HEIGHTMAPS = Maps.newConcurrentMap();

    public static boolean canSeeSky(BlockPos pos, World world) {
        int height = SpawningHeightmap.getHeight(pos, world).join();
        return height <= pos.func_177956_o() + 1;
    }

    public static CompletableFuture<Integer> getHeight(BlockPos pos, World world) {
        if (ServerLifecycleHooks.getCurrentServer().func_213162_bc()) {
            return CompletableFuture.completedFuture(SpawningHeightmap.getHeightSync(pos, world));
        }
        return CompletableFuture.supplyAsync(() -> SpawningHeightmap.getHeightSync(pos, world), (Executor)ServerLifecycleHooks.getCurrentServer());
    }

    private static int getHeightSync(BlockPos pos, World world) {
        int height;
        Chunk chunk = world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        ChunkPos chunkPos = chunk.func_76632_l();
        String key = SpawningHeightmap.getKey(world, chunkPos);
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        Heightmap seesSkyHeights = SEES_SKY_HEIGHTMAPS.get(key);
        if (seesSkyHeights != null && (height = seesSkyHeights.func_202273_a(x, z)) != 0) {
            return height;
        }
        if (seesSkyHeights == null) {
            seesSkyHeights = new Heightmap((IChunk)chunk, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
            seesSkyHeights.field_222693_d = blockState -> !BetterSpawnerConfig.doesBlockSeeSky(blockState);
        }
        height = SpawningHeightmap.calculateHeight(seesSkyHeights, chunk, pos.func_239590_i_());
        seesSkyHeights.func_202272_a(x, z, height);
        SEES_SKY_HEIGHTMAPS.put(key, seesSkyHeights);
        return height;
    }

    private static int calculateHeight(Heightmap canSeeSky, Chunk chunk, BlockPos.Mutable blockpos$mutable) {
        for (int y = chunk.func_76625_h() + 16; y >= 0; --y) {
            blockpos$mutable.func_185336_p(y);
            BlockState state = chunk.func_180495_p((BlockPos)blockpos$mutable);
            if (!canSeeSky.field_222693_d.test(state)) continue;
            return y;
        }
        return 0;
    }

    @SubscribeEvent
    public static void blockUpdate(BlockEvent.NeighborNotifyEvent event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        BlockPos pos = event.getPos();
        Chunk chunk = world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        String key = SpawningHeightmap.getKey((World)world, chunk.func_76632_l());
        Heightmap seesSkyHeights = SEES_SKY_HEIGHTMAPS.get(key);
        if (seesSkyHeights != null) {
            seesSkyHeights.func_202270_a(x, pos.func_177956_o(), z, event.getState());
        } else {
            seesSkyHeights = new Heightmap((IChunk)chunk, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
            seesSkyHeights.field_222693_d = blockState -> !BetterSpawnerConfig.doesBlockSeeSky(blockState);
            int height = SpawningHeightmap.calculateHeight(seesSkyHeights, chunk, pos.func_239590_i_());
            seesSkyHeights.func_202272_a(x, z, height);
            SEES_SKY_HEIGHTMAPS.put(key, seesSkyHeights);
        }
    }

    @SubscribeEvent
    public static void loadSpawningHeightmap(ChunkDataEvent.Load event) {
        if (event.getStatus() != ChunkStatus.Type.LEVELCHUNK) {
            return;
        }
        if (event.getData().func_74764_b("CanSeeSkyHeightMap") && event.getData().func_74764_b("HeightMapChunkKey")) {
            Heightmap canSeeSky = new Heightmap(event.getChunk(), Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
            canSeeSky.field_222693_d = blockState -> !BetterSpawnerConfig.doesBlockSeeSky(blockState);
            canSeeSky.func_202268_a(event.getData().func_197645_o("CanSeeSkyHeightMap"));
            String key = event.getData().func_74779_i("HeightMapChunkKey");
            SEES_SKY_HEIGHTMAPS.put(key, canSeeSky);
        }
    }

    @SubscribeEvent
    public static void saveSpawningHeightmap(ChunkDataEvent.Save event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        String key = SpawningHeightmap.getKey((World)world, event.getChunk().func_76632_l());
        if (SEES_SKY_HEIGHTMAPS.containsKey(key)) {
            Heightmap seesSky = SEES_SKY_HEIGHTMAPS.get(key);
            event.getData().func_197644_a("CanSeeSkyHeightMap", seesSky.func_202269_a());
            event.getData().func_74778_a("HeightMapChunkKey", key);
            SEES_SKY_HEIGHTMAPS.remove(key);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        String key = SpawningHeightmap.getKey((World)world, event.getChunk().func_76632_l());
        SEES_SKY_HEIGHTMAPS.remove(key);
    }

    private static String getKey(World world, ChunkPos pos) {
        String dimensionKey = world.func_234923_W_().func_240901_a_().toString();
        String chunkKey = pos.toString();
        return dimensionKey + ": " + chunkKey;
    }
}

