/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawningHeightmap;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CurryCheckSpawns
implements CheckSpawns {
    @Override
    public String getPermissionNode() {
        return "pixelmon.checkspawns.curry";
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSource sender, List<String> arguments) {
        ServerPlayerEntity target = null;
        if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
            PlayerList playerList = sender.func_197028_i().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
            if (target == null) {
                sender.func_197030_a((ITextComponent)TextHelper.translate(TextFormatting.RED, "spawning.error.mustbeplayer"), false);
                return;
            }
        }
        if (target == null) {
            target = (ServerPlayerEntity)sender.func_197022_f();
        }
        ArrayList<SpawnLocation> spawnLocations = new ArrayList<SpawnLocation>();
        SpatialData data = spawner.calculateSpatialData((World)target.func_71121_q(), target.func_233580_cy_(), 6, true, s -> true);
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_233580_cy_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_BITTER}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(target.func_233580_cy_()), SpawningHeightmap.canSeeSky(target.func_233580_cy_(), (World)target.func_71121_q()), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_233580_cy_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_DRY}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(target.func_233580_cy_()), SpawningHeightmap.canSeeSky(target.func_233580_cy_(), (World)target.func_71121_q()), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_233580_cy_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_NONE}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(target.func_233580_cy_()), SpawningHeightmap.canSeeSky(target.func_233580_cy_(), (World)target.func_71121_q()), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_233580_cy_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_SOUR}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(target.func_233580_cy_()), SpawningHeightmap.canSeeSky(target.func_233580_cy_(), (World)target.func_71121_q()), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_233580_cy_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_SPICY}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(target.func_233580_cy_()), SpawningHeightmap.canSeeSky(target.func_233580_cy_(), (World)target.func_71121_q()), 6, 1));
        spawnLocations.add(new SpawnLocation((Entity)target, new MutableLocation((World)target.func_71121_q(), target.func_233580_cy_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CURRY_SWEET}), data.baseBlock, data.uniqueSurroundingBlocks, target.func_71121_q().func_226691_t_(target.func_233580_cy_()), SpawningHeightmap.canSeeSky(target.func_233580_cy_(), (World)target.func_71121_q()), 6, 1));
        HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
        for (SpawnLocation spawnLocation : spawnLocations) {
            List<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
            if (spawns.isEmpty()) continue;
            possibleSpawns.put(spawnLocation, spawns);
        }
        sender.func_197028_i().execute(() -> {
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            List<IFormattableTextComponent> messages = this.generateMessages(percentages, arguments);
            messages.add(0, TextHelper.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            messages.forEach(message -> sender.func_197030_a((ITextComponent)message, false));
        });
    }
}

