/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.collection;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.ForgeI18n;

public class SpawnInfoCollection
extends SpawnInfo {
    public static final String TYPE_ID_COLLECTION = "collection";
    public String collectionLabel = "spawning.collections.default";
    public ArrayList<SpawnInfo> collection = new ArrayList();

    public SpawnInfoCollection() {
        super(TYPE_ID_COLLECTION);
    }

    @Override
    public void onExport() {
        super.onExport();
        for (SpawnInfo spawnInfo : this.collection) {
            spawnInfo.onExport();
        }
    }

    @Override
    public void onImport() {
        super.onImport();
        for (SpawnInfo spawnInfo : this.collection) {
            spawnInfo.onImport();
        }
    }

    @Override
    public boolean fits(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        if (!super.fits(spawner, spawnLocation)) {
            return false;
        }
        for (SpawnInfo spawnInfo : this.collection) {
            if (!spawnInfo.fits(spawner, spawnLocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SpawnAction<? extends Entity> construct(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        ArrayList<SpawnInfo> suitable = new ArrayList<SpawnInfo>();
        this.collection.forEach(spawnInfo -> {
            if (spawnInfo.fits(spawner, spawnLocation)) {
                suitable.add((SpawnInfo)spawnInfo);
            }
        });
        SpawnInfo selection = spawner.selectionAlgorithm.choose(spawner, spawnLocation, suitable);
        if (selection != null) {
            return selection.construct(spawner, spawnLocation);
        }
        return null;
    }

    @Override
    public String toString() {
        return ForgeI18n.parseMessage((String)this.collectionLabel, (Object[])new Object[0]);
    }
}

