/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.selection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.selection.PartySelectionFactory;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.selection.OpenSelectionPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.selection.SetSelectionOptionsPacket;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PartySelectionScreen {
    public static void openSelection(ServerPlayerEntity player, BiConsumer<ServerPlayerEntity, List<Pokemon>> consumer) {
        PartySelectionScreen.builder().party((PlayerEntity)player).consumer(consumer).sendTo(player);
    }

    public static void openSelection(ServerPlayerEntity player, BiConsumer<ServerPlayerEntity, List<Pokemon>> consumer, Pokemon ... options) {
        PartySelectionScreen.builder().options(options).consumer(consumer).sendTo(player);
    }

    public static void openSelection(ServerPlayerEntity player, int selections, BiConsumer<ServerPlayerEntity, List<Pokemon>> consumer, Pokemon ... options) {
        PartySelectionScreen.builder().selections(selections).consumer(consumer).options(options).sendTo(player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ITextComponent title = new StringTextComponent("");
        private ITextComponent text = new StringTextComponent("");
        private List<Pokemon> options = Lists.newArrayList();
        private int selections = 6;
        private boolean allowExit = false;
        private BiConsumer<ServerPlayerEntity, List<Pokemon>> consumer = null;

        public Builder title(ITextComponent title) {
            this.title = (ITextComponent)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder title(String title) {
            this.title = new StringTextComponent((String)Preconditions.checkNotNull((Object)title, (Object)"title"));
            return this;
        }

        public Builder text(ITextComponent text) {
            this.text = (ITextComponent)Preconditions.checkNotNull((Object)text, (Object)"text");
            return this;
        }

        public Builder text(String text) {
            this.text = new StringTextComponent((String)Preconditions.checkNotNull((Object)text, (Object)"text"));
            return this;
        }

        public Builder selections(int selections) {
            this.selections = selections > 6 ? 6 : Math.max(selections, 1);
            return this;
        }

        public Builder option(Pokemon pokemon) {
            return this.options(pokemon);
        }

        public Builder options(Pokemon ... pokemons) {
            return this.options(Lists.newArrayList((Object[])pokemons));
        }

        public Builder options(List<Pokemon> options) {
            if (this.options.size() + options.size() > 6) {
                return this;
            }
            this.options.addAll(options);
            return this;
        }

        public Builder clearOptions() {
            this.options.clear();
            return this;
        }

        public Builder party(PlayerEntity player) {
            this.options.clear();
            this.options(StorageProxy.getParty(player.func_110124_au()).getAll());
            return this;
        }

        public Builder consumer(BiConsumer<ServerPlayerEntity, List<Pokemon>> consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder enforceSelection() {
            this.allowExit = false;
            return this;
        }

        public Builder allowExit() {
            this.allowExit = true;
            return this;
        }

        public void sendTo(ServerPlayerEntity player) {
            PartySelectionFactory.beginSelection(player, this.consumer, this.options);
            NetworkHelper.sendPacket(new OpenSelectionPacket(this.title, this.text, this.selections, this.allowExit), player);
            for (int i = 0; i < this.options.size(); ++i) {
                NetworkHelper.sendPacket(new SetSelectionOptionsPacket(i, this.options.get(i)), player);
            }
        }
    }
}

