/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.replacement.logic;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.replacement.logic.AbstractReplacementLogic;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class SimpleReplacementLogic
extends AbstractReplacementLogic {
    protected List<PokemonSpecification> replacements = Lists.newArrayList();

    public SimpleReplacementLogic() {
        super("simple");
    }

    public SimpleReplacementLogic(String id) {
        super(id);
    }

    @Override
    public void replaceSpawn(EntityJoinWorldEvent event) {
        event.setCanceled(true);
        if (this.replacements.isEmpty()) {
            return;
        }
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
        PokemonSpecification replacement = RandomHelper.getRandomElementFromCollection(this.replacements);
        PixelmonEntity pixelmonEntity = replacement.create(event.getWorld());
        pixelmonEntity.func_70107_b(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_());
        if (event.getEntity().func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            pixelmonEntity.setAggression(Aggression.AGGRESSIVE);
        } else {
            pixelmonEntity.setAggression(Aggression.PASSIVE);
        }
        EntityClassification classification = event.getEntity().getClassification(true);
        pixelmonEntity.setSpawnReplaceClassification(classification);
        if (classification == EntityClassification.WATER_AMBIENT || classification == EntityClassification.WATER_CREATURE) {
            pixelmonEntity.setSpawnLocation(SpawnLocationType.WATER);
        }
        pixelmonEntity.resetAI();
        executor.func_212871_a_((Runnable)new TickDelayedTask(0, () -> event.getWorld().func_217376_c((Entity)pixelmonEntity)));
    }

    @Override
    public void read(Gson context, JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        if (!object.has("specs")) {
            return;
        }
        for (JsonElement specs : object.getAsJsonArray("specs")) {
            this.replacements.add(PokemonSpecificationProxy.create(specs.getAsString()));
        }
    }
}

