/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.swimming.SwimmingParameters;
import java.lang.reflect.Type;

public class SwimmingParametersTypeAdapter
implements JsonSerializer<SwimmingParameters>,
JsonDeserializer<SwimmingParameters> {
    public SwimmingParameters deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        boolean shouldSink = false;
        JsonObject jsonObject = json.getAsJsonObject();
        int depthRangeStart = jsonObject.get("depthRangeStart").getAsInt();
        int depthRangeEnd = jsonObject.get("depthRangeEnd").getAsInt();
        float swimSpeed = jsonObject.get("swimSpeed").getAsFloat();
        float decayRate = jsonObject.get("decayRate").getAsFloat();
        int refreshRate = jsonObject.get("refreshRate").getAsInt();
        if (jsonObject.has("shouldSink")) {
            shouldSink = jsonObject.get("shouldSink").getAsBoolean();
        }
        return new SwimmingParameters(depthRangeStart, depthRangeEnd, swimSpeed, decayRate, refreshRate, shouldSink);
    }

    public JsonElement serialize(SwimmingParameters src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.add("depthRangeStart", (JsonElement)new JsonPrimitive((Number)src.getDepthRangeStart()));
        object.add("depthRangeEnd", (JsonElement)new JsonPrimitive((Number)src.getDepthRangeEnd()));
        object.add("swimSpeed", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getSwimSpeed())));
        object.add("decayRate", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getDecayRate())));
        object.add("refreshRate", (JsonElement)new JsonPrimitive((Number)src.getRefreshRate()));
        object.add("shouldSink", (JsonElement)new JsonPrimitive(Boolean.valueOf(src.isShouldSink())));
        return object;
    }
}

