/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.species.DataCopier;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.util.helpers.JsonHelper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;

public class SpeciesTypeAdapter
implements JsonSerializer<Species>,
JsonDeserializer<Species> {
    public Species deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        DataCopier.resetAll();
        JsonObject object = json.getAsJsonObject();
        String name = object.get("name").getAsString();
        String translationKey = object.has("translationKey") ? object.get("translationKey").getAsString() : "";
        int dex = object.get("dex").getAsInt();
        int generation = object.has("generation") ? object.get("generation").getAsInt() : -1;
        ImmutableList<String> defaultForms = JsonHelper.deserializeList(object.getAsJsonArray("defaultForms"), jsonElement -> jsonElement.getAsString().toLowerCase(Locale.ROOT));
        ImmutableList<Stats> forms = JsonHelper.deserializeList(object.getAsJsonArray("forms"), elem -> (Stats)context.deserialize(elem, Stats.class));
        return new Species(name, translationKey, dex, generation, (Collection<String>)defaultForms, (Collection<Stats>)forms, object.toString());
    }

    public JsonElement serialize(Species species, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", species.getName());
        object.addProperty("translationKey", species.getTranslationKey());
        object.addProperty("dex", (Number)species.getDex());
        object.addProperty("generation", (Number)species.getGeneration());
        object.add("defaultForms", (JsonElement)JsonHelper.serializeList(species.getDefaultFormNames(), JsonPrimitive::new));
        object.add("forms", (JsonElement)JsonHelper.serializeList(species.getForms(), arg_0 -> ((JsonSerializationContext)context).serialize(arg_0)));
        return object;
    }
}

