/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.export;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.FormData;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class ImportExportForm {
    private static final Map<Integer, Map<String, String>> SPECIES_DATA = new HashMap<Integer, Map<String, String>>();
    private static final Map<String, FormData> nameMap = new HashMap<String, FormData>();

    public static void addSpeciesFormData(Species species, String ... formNames) {
        ImportExportForm.addFormData(species, "");
        for (int i = 0; i < formNames.length; i = (int)((short)(i + 1))) {
            ImportExportForm.addFormData(species, formNames[i]);
        }
    }

    public static void addFormData(Species species, String formName) {
        Map formMap = SPECIES_DATA.computeIfAbsent(species.getDex(), ___ -> Maps.newHashMap());
        Stats stats = species.getForm(formName);
        if (stats == null) {
            return;
        }
        String fullFormName = stats.getName();
        if (!formName.isEmpty()) {
            fullFormName = fullFormName + "-" + formName;
        }
        formMap.put(formName, fullFormName);
        nameMap.put(fullFormName, new FormData(species, formName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<FormData> getFormData(String formName) {
        if (!formName.contains("-")) return Optional.empty();
        String pokemon = formName.substring(0, formName.indexOf("-")).trim();
        String form = formName.substring(formName.indexOf("-") + 1).trim().replace("-", "");
        Species species = PixelmonSpecies.fromName(pokemon).orElse(PixelmonSpecies.MISSINGNO);
        if (species == null) return Optional.empty();
        for (Stats f : species.getForms()) {
            if (!f.getName().equalsIgnoreCase(form) && (!form.equalsIgnoreCase("none") || !f.isDefault())) continue;
            return Optional.of(new FormData(species, f.getName()));
        }
        if (!nameMap.containsKey(formName)) return Optional.empty();
        return Optional.of(nameMap.get(formName));
    }

    public static boolean getGmaxData(String formName) {
        return formName.toLowerCase(Locale.ROOT).contains("gmax");
    }

    static {
        ImportExportForm.addFormData(PixelmonSpecies.UNOWN.getValueUnsafe(), "question");
        ImportExportForm.addFormData(PixelmonSpecies.UNOWN.getValueUnsafe(), "exclamation");
        for (int i = 1; i < 26; i = (int)((short)(i + 1))) {
            ImportExportForm.addFormData(PixelmonSpecies.UNOWN.getValueUnsafe(), Character.toString((char)(65 + i)));
        }
        String[] burmyForms = new String[]{"Sandy", "Trash"};
        ImportExportForm.addSpeciesFormData(PixelmonSpecies.BURMY.getValueUnsafe(), burmyForms);
        ImportExportForm.addSpeciesFormData(PixelmonSpecies.WORMADAM.getValueUnsafe(), burmyForms);
        ImportExportForm.addSpeciesFormData(PixelmonSpecies.CASTFORM.getValueUnsafe(), "Snowy", "Rainy", "Sunny");
        ImportExportForm.addSpeciesFormData(PixelmonSpecies.DEOXYS.getValueUnsafe(), "attack", "Defense", "speed");
    }
}

