/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.catching;

import com.google.common.collect.Maps;
import java.util.Map;

public class CaptureValues {
    public static final String A = "A";
    public static final String B = "B";
    public static final String C = "C";
    public static final String D = "D";
    public static final String E = "E";
    public static final String F = "F";
    private int catchRate;
    private double ballBonus;
    private boolean canCritical = true;
    private boolean critical = false;
    private boolean caught = false;
    private int shakes = 0;
    private final Map<String, Double> variables = Maps.newHashMap();

    public CaptureValues(int catchRate, double ballBonus) {
        this.setCatchRate(catchRate);
        this.setBallBonus(ballBonus);
    }

    public int getCatchRate() {
        return this.catchRate;
    }

    public void setCatchRate(int catchRate) {
        this.catchRate = Math.max(1, Math.min(255, catchRate));
    }

    public double getBallBonus() {
        return this.ballBonus;
    }

    public void setBallBonus(double ballBonus) {
        this.ballBonus = Math.max(0.0, ballBonus);
    }

    public void disableCritical() {
        this.canCritical = false;
    }

    public void enableCritical() {
        this.canCritical = true;
    }

    public void setCanCritical(boolean canCritical) {
        this.canCritical = canCritical;
    }

    public boolean canCritical() {
        return this.canCritical;
    }

    public boolean isCritical() {
        return this.canCritical && this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public void setCritical() {
        this.critical = true;
    }

    public int getShakes() {
        return this.shakes;
    }

    public void setShakes(int shakes) {
        this.shakes = shakes;
    }

    public void addShake() {
        ++this.shakes;
    }

    public boolean isCaught() {
        return this.caught;
    }

    public void setCaught(boolean caught) {
        this.caught = caught;
    }

    public void setCaught() {
        this.caught = true;
    }

    public void setCaught(int shakes) {
        this.setShakes(shakes);
        this.setCaught();
    }

    public boolean trySetCaught(int targetShakes) {
        if (this.shakes >= targetShakes) {
            this.setCaught();
            return true;
        }
        return false;
    }

    public double getVariable(String key) {
        return this.variables.computeIfAbsent(key, v -> 0.0);
    }

    public void setVariable(String key, double value) {
        this.variables.put(key, value);
    }
}

