/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.catching;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureMethod;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureMethods;
import java.util.Locale;
import java.util.Map;

public class CaptureMethodRegistry {
    private static final Map<String, CaptureMethod> CAPTURE_METHODS = Maps.newHashMap();
    private static CaptureMethod FALLBACK = null;

    public static void registerCaptureMethod(CaptureMethod method, String ... keys) {
        for (String key : keys) {
            CAPTURE_METHODS.put(key.toLowerCase(Locale.ROOT), method);
        }
    }

    public static CaptureMethod getCaptureMethod(String key) {
        return CAPTURE_METHODS.getOrDefault(key.toLowerCase(Locale.ROOT), CaptureMethodRegistry.getFallbackCaptureMethod());
    }

    public static void setFallbackCaptureMethod(CaptureMethod method) {
        FALLBACK = method;
    }

    public static CaptureMethod getFallbackCaptureMethod() {
        if (FALLBACK == null) {
            FALLBACK = CAPTURE_METHODS.get(PixelmonConfigProxy.getGeneral().getFallbackCaptureMethod());
        }
        return FALLBACK;
    }

    static {
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.GEN_1, "1", "gen1");
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.GEN_2, "2", "gen2");
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.GEN_3_4, "3", "4", "gen3", "gen4");
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.GEN_5, "5", "gen5");
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.GEN_6_7, "6", "7", "gen6", "gen7");
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.GEN_8, "8", "gen8");
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.ALWAYS_CAPTURE, "100%", "always");
        CaptureMethodRegistry.registerCaptureMethod(CaptureMethods.FIFTY_FIFTY, "50%", "5050", "fiftyfifty");
    }
}

