/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.CopiedBoosts;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class Opportunist
extends AbstractAbility {
    private static boolean boostFromOpportunist = false;

    @Override
    public void onStatIncrease(PixelmonWrapper pw, PixelmonWrapper affected, int amount, BattleStatsType stat) {
        if (!pw.bc.simulateMode && !pw.bc.simulateStats && pw.isOpponent(affected) && !boostFromOpportunist) {
            CopiedBoosts boosts = (CopiedBoosts)pw.getStatus(StatusType.StoredBoosts);
            if (boosts == null) {
                boosts = new CopiedBoosts();
                pw.addStatus(boosts, pw);
            }
            boosts.addBoost(amount, stat);
        }
    }

    @Override
    public void applyEffectOnStatModified(PixelmonWrapper pw, PixelmonWrapper affected) {
        CopiedBoosts storedBoosts = (CopiedBoosts)pw.getStatus(StatusType.StoredBoosts);
        if (storedBoosts != null && !pw.bc.simulateMode && !pw.bc.simulateStats) {
            BattleStatsType[] stats = storedBoosts.types.toArray(new BattleStatsType[0]);
            int[] boosts = storedBoosts.counts;
            pw.removeStatus(storedBoosts);
            this.sendActivatedMessage(pw);
            boostFromOpportunist = true;
            pw.getBattleStats().modifyStat(boosts, stats);
            boostFromOpportunist = false;
        }
    }
}

