/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Illusion;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Transformed;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.entity.Entity;

public class Imposter
extends AbstractAbility {
    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.simulateMode) {
            return;
        }
        PixelmonWrapper target = newPokemon.bc.getOppositePokemon(newPokemon);
        if (target == null) {
            return;
        }
        if (!target.getBattleAbility().canBeCopied()) {
            return;
        }
        if (target.getBattleAbility() instanceof Illusion && ((Illusion)target.getBattleAbility()).disguisedPokemon != null || target.hasStatus(StatusType.Substitute, StatusType.Transformed)) {
            return;
        }
        if (target.isFainted()) {
            return;
        }
        newPokemon.bc.sendToAll("pixelmon.abilities.imposter", newPokemon.getNickname(), target.getNickname());
        if (newPokemon.entity != null) {
            PixelmonEntity.SYNC_TRANSFORMATION.set((Entity)newPokemon.entity, (Object)-1);
        }
        newPokemon.addStatus(new Transformed(newPokemon, target), target);
        Moveset tempMoveset = new Moveset().withPokemon(newPokemon.pokemon);
        for (Attack a : target.getMoveset()) {
            if (a == null) continue;
            Attack copy = a.copy();
            copy.pp = 5;
            copy.overridePPMax(5);
            tempMoveset.add(copy);
        }
        newPokemon.setTemporaryMoveset(tempMoveset);
        Transformed transformedStatus = (Transformed)newPokemon.getStatus(StatusType.Transformed);
        if (transformedStatus != null) {
            transformedStatus.changeTransformedSprite(newPokemon, target);
        }
    }

    @Override
    public void applyFoeSwitchInEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (!user.hasStatus(StatusType.Transformed)) {
            this.applySwitchInEffect(user);
        }
    }
}

