/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Rainy;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.battles.status.Weather;

public class DrySkin
extends AbstractAbility {
    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        if (pokemon.bc == null) {
            return;
        }
        Weather weather = pokemon.bc.globalStatusController.getWeather();
        if (weather instanceof Rainy && !pokemon.hasFullHealth()) {
            pokemon.bc.sendToAll("pixelmon.abilities.dryskinrain", pokemon.getNickname());
            pokemon.healByPercent(12.5f);
        }
        if (weather instanceof Sunny && pokemon.isAlive()) {
            pokemon.bc.sendToAll("pixelmon.abilities.dryskinsun", pokemon.getNickname());
            pokemon.doBattleDamage(pokemon, pokemon.getPercentMaxHealth(12.5f), DamageTypeEnum.ABILITY);
        }
    }

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (a.getType() == Element.WATER) {
            if (pokemon.hasFullHealth()) {
                user.bc.sendToAll("pixelmon.abilities.dryskinnegate", pokemon.getNickname());
            } else {
                int healAmount = pokemon.getPercentMaxHealth(25.0f);
                pokemon.healEntityBy(healAmount);
                user.bc.sendToAll("pixelmon.abilities.dryskinrain", pokemon.getNickname());
                a.moveResult.weightMod -= pokemon.getHealPercent(healAmount);
            }
            return false;
        }
        return true;
    }

    @Override
    public int modifyDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper pokemon, Attack a) {
        if (a.getType() == Element.FIRE) {
            return (int)((double)damage * 1.25);
        }
        return damage;
    }
}

