/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokedex;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import net.minecraft.world.World;

public class PokedexEntry {
    private final String name;
    private final int natPokedexNum;
    private final String heightM;
    private final String weightM;
    private final String heightC;
    private final String weightC;
    private PixelmonEntity renderTarget;

    public PokedexEntry(int i, String n, float w, float h) {
        this.natPokedexNum = i;
        this.name = n;
        this.heightM = h + "";
        this.weightM = w + "";
        float hc = h * 3.28084f;
        if (hc == 0.0f) {
            this.heightC = "??? ft.";
        } else {
            String s = hc + "";
            int i1 = s.indexOf(46);
            String feet = s.substring(0, i1);
            float inches = Float.parseFloat(0 + s.substring(i1)) * 12.0f;
            int in = Math.round(inches);
            this.heightC = feet + "'" + in + "\"";
        }
        float wc = w * 2.2046225f;
        this.weightC = wc == 0.0f ? "???" : String.valueOf(Math.round(wc));
    }

    public PokedexEntry(int i, String n) {
        this.natPokedexNum = i;
        this.name = n;
        this.weightC = "???";
        this.weightM = "???";
        this.heightC = "???";
        this.heightM = "???";
    }

    public String getName() {
        return this.name;
    }

    public String getPokedexDisplayNumber() {
        String s = "" + this.natPokedexNum;
        while (s.length() < 3) {
            s = "0" + s;
        }
        return s;
    }

    public PixelmonEntity getRenderTarget(World w) {
        if (this.renderTarget != null && w == this.renderTarget.field_70170_p) {
            return this.renderTarget;
        }
        if (this.name == null || this.name.equals("???") || !PixelmonSpecies.fromName(this.name).isInitialized()) {
            return null;
        }
        this.renderTarget = new PixelmonEntity(w, PokemonFactory.create(PixelmonSpecies.fromName(this.name).getValueUnsafe()));
        this.renderTarget.getLvl().setLevel(50);
        this.renderTarget.getPokemon().setGrowth(EnumGrowth.Ordinary);
        return this.renderTarget;
    }

    public String toString() {
        return this.getPokedexDisplayNumber() + " " + this.name;
    }
}

