/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.moveskills;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.moveskills.MoveSkillCooldownEvent;
import com.pixelmonmod.pixelmon.api.events.moveskills.UseMoveSkillEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.moveskills.RegisterMoveSkillPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.Event;

public class MoveSkill {
    public static final List<MoveSkill> moveSkills = Lists.newCopyOnWriteArrayList();
    public String id;
    public String name;
    public ArrayList<String> descriptions = new ArrayList();
    public ResourceLocation sprite;
    public int cooldownTicks = 100;
    public int range = 3;
    public Set<Lazy<ImmutableAttack>> anyMoves = Sets.newHashSet();
    public Set<Lazy<ImmutableAttack>> combinationMoves = Sets.newHashSet();
    public Set<Lazy<PokemonSpecification>> ableSpecs = Sets.newHashSet();
    public Set<Lazy<PokemonSpecification>> intrinsicSpecs = Sets.newHashSet();
    public boolean usePP = false;
    public Map<EnumTargetType, BiFunction<PixelmonEntity, Object, Integer>> behaviours = Maps.newHashMap();

    public static boolean isMoveSkill(String moveSkillID) {
        return MoveSkill.getMoveSkillByID(moveSkillID) != null;
    }

    public static MoveSkill getMoveSkillByID(String moveSkillID) {
        return CollectionHelper.find(moveSkills, moveSkill -> moveSkill.id.equalsIgnoreCase(moveSkillID));
    }

    public static List<MoveSkill> getMoveSkills(Pokemon pokemon) {
        ArrayList moveSkills = Lists.newArrayList(MoveSkill.moveSkills);
        moveSkills.removeIf(moveSkill -> !moveSkill.hasMoveSkill(pokemon));
        return moveSkills;
    }

    public MoveSkill(String id) {
        this.id = id;
        this.name = id;
    }

    public MoveSkill describe(String ... descriptions) {
        Collections.addAll(this.descriptions, descriptions);
        return this;
    }

    public void onUsed(PixelmonEntity pixelmon, Object data, EnumTargetType targetType) {
        int cooldownTicks;
        if (targetType == EnumTargetType.PLAYER && !(data instanceof ServerPlayerEntity)) {
            return;
        }
        if (targetType == EnumTargetType.POKEMON && !(data instanceof PixelmonEntity)) {
            return;
        }
        if (targetType == EnumTargetType.MISC_ENTITY && !(data instanceof LivingEntity)) {
            return;
        }
        if (targetType == EnumTargetType.BLOCK && !(data instanceof Tuple)) {
            return;
        }
        BiFunction<PixelmonEntity, Object, Integer> cooldown = this.behaviours.getOrDefault((Object)targetType, (p, d) -> -1);
        UseMoveSkillEvent event = new UseMoveSkillEvent(pixelmon, this, data);
        if (this.usePP && !this.checkForPP(pixelmon.getPokemon())) {
            ChatHandler.sendFormattedChat((ICommandSource)pixelmon.getOwner(), TextFormatting.RED, "pixelmon.moveskill.nopp", pixelmon.func_145748_c_());
            return;
        }
        if (!Pixelmon.EVENT_BUS.post((Event)event) && (cooldownTicks = cooldown.apply(pixelmon, data).intValue()) > 0) {
            if (this.usePP) {
                this.takePP(pixelmon.getPokemon());
            }
            MoveSkillCooldownEvent cooldownEvent = new MoveSkillCooldownEvent(pixelmon, this, cooldownTicks);
            if (event.handler != null) {
                event.handler.accept(cooldownEvent);
            } else if (Pixelmon.EVENT_BUS.post((Event)cooldownEvent) || cooldownEvent.cooldownTicks <= 0) {
                return;
            }
            this.applyCooldown(pixelmon.getPokemon(), cooldownEvent.cooldownTicks);
        }
    }

    public void applyCooldown(Pokemon pokemon, int cooldownTicks) {
        if (cooldownTicks < 1) {
            cooldownTicks = 1;
        }
        pokemon.setMoveSkillCooldown(this, cooldownTicks);
    }

    public boolean hasMoveSkill(Pokemon pokemon) {
        if (this.matchesIntrinsicSpecs(pokemon)) {
            return true;
        }
        if (!this.ableSpecs.isEmpty() && !this.matchesAbleSpecs(pokemon)) {
            return false;
        }
        if (!this.combinationMoves.isEmpty() && !this.matchesCombinationMoves(pokemon)) {
            return false;
        }
        return this.anyMoves.isEmpty() || this.matchesAnyMoves(pokemon);
    }

    public MoveSkill setName(String name) {
        this.name = name;
        return this;
    }

    public MoveSkill setDefaultCooldownTicks(int cooldownTicks) {
        this.cooldownTicks = cooldownTicks;
        return this;
    }

    public MoveSkill setRange(int range) {
        this.range = range;
        return this;
    }

    public MoveSkill setIcon(ResourceLocation resourceLocation) {
        this.sprite = resourceLocation;
        return this;
    }

    public MoveSkill setAnyMoves(String ... anyMoves) {
        for (String anyMove : anyMoves) {
            this.anyMoves.add((Lazy<ImmutableAttack>)Lazy.of(() -> AttackRegistry.getAttackBase(anyMove).orElse(null)));
        }
        return this;
    }

    public MoveSkill setAnyMoves(List<ImmutableAttack> anyMoves) {
        this.anyMoves = Sets.newHashSet();
        for (ImmutableAttack attack : anyMoves) {
            this.anyMoves.add((Lazy<ImmutableAttack>)Lazy.of(() -> attack));
        }
        return this;
    }

    public MoveSkill setCombinationMoves(String ... combinationMoves) {
        this.combinationMoves = Sets.newHashSet();
        for (String combinationMove : combinationMoves) {
            this.combinationMoves.add((Lazy<ImmutableAttack>)Lazy.of(() -> AttackRegistry.getAttackBase(combinationMove).orElse(null)));
        }
        return this;
    }

    public MoveSkill setCombinationMoves(List<ImmutableAttack> combinationMoves) {
        this.combinationMoves = Sets.newHashSet();
        for (ImmutableAttack attack : combinationMoves) {
            this.combinationMoves.add((Lazy<ImmutableAttack>)Lazy.of(() -> attack));
        }
        return this;
    }

    public MoveSkill setAbleSpecs(List<PokemonSpecification> specs) {
        this.ableSpecs = Sets.newHashSet();
        for (PokemonSpecification spec : specs) {
            this.ableSpecs.add((Lazy<PokemonSpecification>)Lazy.of(() -> PokemonSpecificationProxy.create(spec.toString())));
        }
        return this;
    }

    public MoveSkill setIntrinsicSpecs(List<PokemonSpecification> specs) {
        this.intrinsicSpecs = Sets.newHashSet();
        for (PokemonSpecification spec : specs) {
            this.intrinsicSpecs.add((Lazy<PokemonSpecification>)Lazy.of(() -> PokemonSpecificationProxy.create(spec.toString())));
        }
        return this;
    }

    public MoveSkill setBehaviourNoTarget(Function<PixelmonEntity, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.NOTHING, (pixelmon, nothing) -> (Integer)cooldown.apply((PixelmonEntity)pixelmon));
        return this;
    }

    public MoveSkill setBehaviourPokemonTarget(BiFunction<PixelmonEntity, PixelmonEntity, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.POKEMON, (user, target) -> (Integer)cooldown.apply((PixelmonEntity)user, (PixelmonEntity)target));
        return this;
    }

    public MoveSkill setBehaviourBlockTarget(BiFunction<PixelmonEntity, Tuple<BlockPos, Direction>, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.BLOCK, (pixelmon, tup) -> (Integer)cooldown.apply((PixelmonEntity)pixelmon, (Tuple<BlockPos, Direction>)((Tuple)tup)));
        return this;
    }

    public MoveSkill setBehaviourPlayerTarget(BiFunction<PixelmonEntity, ServerPlayerEntity, Integer> cooldown) {
        this.behaviours.put(EnumTargetType.PLAYER, (pixelmon, playerTarget) -> (Integer)cooldown.apply((PixelmonEntity)pixelmon, (ServerPlayerEntity)playerTarget));
        return this;
    }

    public MoveSkill setBehaviourMultiTarget(BiFunction<PixelmonEntity, Object, Integer> cooldown, EnumTargetType ... targetTypes) {
        for (EnumTargetType targetType : targetTypes) {
            this.behaviours.put(targetType, cooldown);
        }
        return this;
    }

    public MoveSkill setUsePP(boolean usePP) {
        this.usePP = usePP;
        return this;
    }

    public boolean hasTargetType(EnumTargetType targetType) {
        return this.behaviours.containsKey((Object)targetType);
    }

    public boolean checkForPP(Pokemon pokemon) {
        if (this.matchesIntrinsicSpecs(pokemon)) {
            return true;
        }
        if (this.combinationMoves.isEmpty()) {
            return true;
        }
        Moveset moveset = pokemon.getMoveset();
        for (Lazy<ImmutableAttack> move : this.combinationMoves) {
            boolean match = false;
            for (Attack attack : moveset) {
                if (!attack.getActualMove().isAttack((ImmutableAttack)move.get())) continue;
                if (attack.pp <= 0) {
                    return false;
                }
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        if (this.anyMoves.isEmpty()) {
            return true;
        }
        for (Lazy<ImmutableAttack> move : this.anyMoves) {
            for (Attack attack : moveset) {
                if (!attack.getActualMove().isAttack((ImmutableAttack)move.get()) || attack.pp <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void takePP(Pokemon pokemon) {
        if (this.matchesIntrinsicSpecs(pokemon)) {
            return;
        }
        if (this.anyMoves.isEmpty() && this.combinationMoves.isEmpty()) {
            return;
        }
        Moveset moveset = pokemon.getMoveset();
        block0: for (Lazy<ImmutableAttack> move : this.combinationMoves) {
            for (Attack attack : moveset) {
                if (!attack.getActualMove().isAttack((ImmutableAttack)move.get()) || attack.pp <= 0) continue;
                --attack.pp;
                continue block0;
            }
        }
        if (!this.combinationMoves.isEmpty()) {
            pokemon.markDirty(EnumUpdateType.Moveset);
            return;
        }
        for (Lazy<ImmutableAttack> move : this.anyMoves) {
            for (Attack attack : moveset) {
                if (!attack.getActualMove().isAttack((ImmutableAttack)move.get()) || attack.pp <= 0) continue;
                --attack.pp;
                pokemon.markDirty(EnumUpdateType.Moveset);
                return;
            }
        }
    }

    public boolean matchesIntrinsicSpecs(Pokemon pokemon) {
        for (Lazy<PokemonSpecification> spec : this.intrinsicSpecs) {
            if (!((PokemonSpecification)spec.get()).matches(pokemon)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAbleSpecs(Pokemon pokemon) {
        boolean match = false;
        for (Lazy<PokemonSpecification> spec : this.ableSpecs) {
            if (!((PokemonSpecification)spec.get()).matches(pokemon)) continue;
            match = true;
            break;
        }
        return match;
    }

    public boolean matchesCombinationMoves(Pokemon pokemon) {
        Moveset moveset = pokemon.getMoveset();
        for (Lazy<ImmutableAttack> attack : this.combinationMoves) {
            if (moveset.hasAttack((ImmutableAttack)attack.get())) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAnyMoves(Pokemon pokemon) {
        Moveset moveset = pokemon.getMoveset();
        boolean match = false;
        for (Lazy<ImmutableAttack> attack : this.anyMoves) {
            if (!moveset.hasAttack((ImmutableAttack)attack.get())) continue;
            match = true;
            break;
        }
        return match;
    }

    public void register(ServerPlayerEntity player) {
        RegisterMoveSkillPacket packet = new RegisterMoveSkillPacket(this, false);
        NetworkHelper.sendPacket(packet, player);
    }

    public void unregister(ServerPlayerEntity player) {
        RegisterMoveSkillPacket packet = new RegisterMoveSkillPacket(this, true);
        NetworkHelper.sendPacket(player, packet);
    }

    public static enum EnumTargetType {
        NOTHING,
        BLOCK,
        POKEMON,
        PLAYER,
        MISC_ENTITY;

    }
}

