/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureValues;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class CaptureEvent
extends Event {
    protected final ServerPlayerEntity player;
    protected PixelmonEntity pokemon;
    protected final PokeBallEntity pokeBall;

    private CaptureEvent(ServerPlayerEntity player, PixelmonEntity pokemon, PokeBallEntity pokeBall) {
        this.player = player;
        this.pokemon = pokemon;
        this.pokeBall = pokeBall;
    }

    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public PixelmonEntity getPokemon() {
        return this.pokemon;
    }

    public PokeBallEntity getPokeBall() {
        return this.pokeBall;
    }

    public void setPokemon(PixelmonEntity pokemon) {
        if (pokemon == null) {
            return;
        }
        this.pokemon = pokemon;
    }

    public static class FailedRaidCapture
    extends CaptureEvent {
        private final Pokemon raidPokemon;
        private final RaidData raid;

        public FailedRaidCapture(ServerPlayerEntity player, Pokemon raidPokemon, RaidData raid) {
            super(player, null, null);
            this.raidPokemon = raidPokemon;
            this.raid = raid;
        }

        public Pokemon getRaidPokemon() {
            return this.raidPokemon;
        }

        public RaidData getRaid() {
            return this.raid;
        }
    }

    public static class FailedCapture
    extends CaptureEvent {
        public FailedCapture(ServerPlayerEntity player, PixelmonEntity pokemon, PokeBallEntity pokeBall) {
            super(player, pokemon, pokeBall);
        }
    }

    @Cancelable
    public static class SuccessfulRaidCapture
    extends CaptureEvent {
        private final Pokemon raidPokemon;
        private final RaidData raid;

        public SuccessfulRaidCapture(ServerPlayerEntity player, Pokemon raidPokemon, RaidData raid) {
            super(player, null, null);
            this.raidPokemon = raidPokemon;
            this.raid = raid;
        }

        public Pokemon getRaidPokemon() {
            return this.raidPokemon;
        }

        public RaidData getRaid() {
            return this.raid;
        }
    }

    @Cancelable
    public static class SuccessfulCapture
    extends CaptureEvent {
        public SuccessfulCapture(ServerPlayerEntity player, PixelmonEntity pokemon, PokeBallEntity pokeBall) {
            super(player, pokemon, pokeBall);
        }
    }

    @Cancelable
    public static class StartRaidCapture
    extends CaptureEvent {
        private final CaptureValues values;
        private final Pokemon raidPokemon;
        private final RaidData raid;

        public StartRaidCapture(ServerPlayerEntity player, Pokemon raidPokemon, RaidData raid, CaptureValues values) {
            super(player, null, null);
            this.values = values;
            this.raid = raid;
            this.raidPokemon = raidPokemon;
        }

        public CaptureValues getCaptureValues() {
            return this.values;
        }

        public Pokemon getRaidPokemon() {
            return this.raidPokemon;
        }

        public RaidData getRaid() {
            return this.raid;
        }
    }

    @Cancelable
    public static class StartCapture
    extends CaptureEvent {
        private final CaptureValues values;

        public StartCapture(ServerPlayerEntity player, PixelmonEntity pokemon, PokeBallEntity pokeBall, CaptureValues values) {
            super(player, pokemon, pokeBall);
            this.values = values;
        }

        public CaptureValues getCaptureValues() {
            return this.values;
        }
    }
}

