/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.dialogue;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.OpenDialogueInputPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DialogueInputScreen {
    public static void openDialogueInput(ServerPlayerEntity player, ITextComponent title, ITextComponent text) {
        Builder builder = DialogueInputScreen.builder().setTitle(title).setText(text);
        builder.sendTo(player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ITextComponent title) {
        return new Builder().setTitle(title);
    }

    public static class Builder {
        private ITextComponent title = new StringTextComponent("");
        private ITextComponent text = null;
        private String defaultText = "";
        private boolean shouldCloseOnEsc = true;

        public Builder setTitle(ITextComponent title) {
            this.title = (ITextComponent)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder setTitle(String title) {
            this.title = new StringTextComponent((String)Preconditions.checkNotNull((Object)title, (Object)"title"));
            return this;
        }

        public Builder setText(ITextComponent text) {
            this.text = (ITextComponent)Preconditions.checkNotNull((Object)text, (Object)"text");
            return this;
        }

        public Builder setText(String text) {
            this.text = new StringTextComponent((String)Preconditions.checkNotNull((Object)text, (Object)"text"));
            return this;
        }

        public Builder setDefaultText(String defaultText) {
            this.defaultText = (String)Preconditions.checkNotNull((Object)defaultText, (Object)"defaultText");
            return this;
        }

        public Builder setShouldCloseOnEsc(boolean b) {
            this.shouldCloseOnEsc = b;
            return this;
        }

        public void sendTo(ServerPlayerEntity player) {
            NetworkHelper.sendPacket(player, new OpenDialogueInputPacket(this.title, this.text, this.defaultText, this.shouldCloseOnEsc));
        }
    }
}

