/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare.impl.requirement;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.AbstractRequirement;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.math.BigDecimal;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class PokeDollarsRequirement
extends AbstractRequirement {
    protected double amount = 0.0;

    public PokeDollarsRequirement() {
        super("pokedollars");
    }

    @Override
    public void read(Gson gson, JsonElement json) {
        JsonObject object = json.getAsJsonObject();
        this.error = TextHelper.colour(object.get("error_message").getAsString());
        if (!object.has("value")) {
            return;
        }
        this.amount = object.get("value").getAsDouble();
    }

    @Override
    public boolean hasMetRequirement(ServerPlayerEntity player, DayCareBox box) {
        Optional<BigDecimal> balance = BankAccountProxy.getBankAccount(player).map(BankAccount::getBalance);
        return balance.isPresent() && balance.get().compareTo(BigDecimal.valueOf(this.amount)) >= 0;
    }

    @Override
    public void takeFrom(ServerPlayerEntity player, DayCareBox box) {
        BankAccountProxy.getBankAccount(player).ifPresent(bankAccount -> bankAccount.take(this.amount));
    }

    @Override
    public void write(CompoundNBT nbt) {
        ListNBT pokedollarRequirement = new ListNBT();
        if (nbt.func_74764_b("pokedollarRequirement")) {
            pokedollarRequirement = nbt.func_150295_c("pokedollarRequirement", 6);
        }
        pokedollarRequirement.add((Object)DoubleNBT.func_229684_a_((double)this.amount));
        nbt.func_218657_a("pokedollarRequirement", (INBT)pokedollarRequirement);
    }

    @Override
    public void read(CompoundNBT nbt) {
        if (!nbt.func_74764_b("pokedollarRequirement")) {
            return;
        }
        ListNBT pokedollarRequirement = nbt.func_150295_c("pokedollarRequirement", 6);
        if (pokedollarRequirement.isEmpty()) {
            return;
        }
        DoubleNBT doubleNBT = (DoubleNBT)pokedollarRequirement.get(0);
        pokedollarRequirement.remove(0);
        this.amount = doubleNBT.func_150286_g();
    }

    public double getAmount() {
        return this.amount;
    }
}

