/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.data;

import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.data.BlockedDataSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.MutableRibbonData;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.enums.EnumBike;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.block.WoodType;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;

public class PixelmonDataSerializers {
    public static final IDataSerializer<PokemonBase> POKEMON_BASE = new BlockedDataSerializer<PokemonBase>((buffer, pokemon) -> {
        buffer.writeInt(pokemon.getSpecies().getDex());
        buffer.func_180714_a(pokemon.getForm().getName());
        buffer.writeInt(pokemon.getGender().ordinal());
        buffer.func_180714_a(pokemon.getPalette().getName());
        buffer.writeInt(pokemon.getEggCycles());
        buffer.writeBoolean(pokemon.getBall() != null);
        if (pokemon.getBall() != null) {
            buffer.func_180714_a(pokemon.getBall().getName());
        }
    }, buffer -> {
        Species species = PixelmonSpecies.fromNationalDex(buffer.readInt());
        if (species == null) {
            buffer.func_218666_n();
            buffer.readInt();
            buffer.func_218666_n();
            buffer.readInt();
            if (buffer.readBoolean()) {
                buffer.func_218666_n();
            }
            return null;
        }
        Stats form = species.getForm(buffer.func_218666_n());
        Gender gender = Gender.getGender((short)buffer.readInt());
        PaletteProperties palette = form.getGenderProperties(gender).getPalette(buffer.func_218666_n());
        int eggCycles = buffer.readInt();
        PokeBall ball = null;
        if (buffer.readBoolean()) {
            ball = PokeBallRegistry.getPokeBall(buffer.func_218666_n()).orElse((PokeBall)null);
        }
        return new PokemonBase(species, form, palette, gender, eggCycles, ball);
    }, pokemon -> new PokemonBase(pokemon.getSpecies(), pokemon.getForm(), pokemon.getPalette(), pokemon.getGender()));
    public static final IDataSerializer<EnumGrowth> GROWTH = new BlockedDataSerializer<EnumGrowth>((buffer, growth) -> buffer.writeInt(growth == null ? -1 : growth.ordinal()), buffer -> EnumGrowth.getGrowthFromIndex(buffer.readInt()), growth -> growth);
    public static final IDataSerializer<BossTier> BOSS_MODE = new BlockedDataSerializer<BossTier>((buffer, bossTier) -> buffer.func_180714_a(bossTier.getID()), buffer -> BossTierRegistry.getBossTierOrNotBoss(buffer.func_218666_n()), bossmode -> bossmode);
    public static final IDataSerializer<Ribbon> RIBBON_TYPE = new BlockedDataSerializer<Ribbon>((buffer, ribbon) -> {
        buffer.writeBoolean(ribbon == null || ribbon.getType() == null);
        if (ribbon != null && ribbon.getType() != null) {
            buffer.func_180714_a(ribbon.getType().getKey());
            buffer.writeLong(ribbon.getReceivedDate());
            buffer.func_179256_a(ribbon.getReceiver());
            ribbon.getRibbonData().writeToBuffer((PacketBuffer)buffer);
        }
    }, buffer -> {
        if (buffer.readBoolean()) {
            return null;
        }
        return Ribbon.builder().type(buffer.func_218666_n()).receivedDate(buffer.readLong()).receiver(buffer.func_179258_d()).ribbonData(MutableRibbonData.fromBuffer(buffer)).build();
    }, ribbon -> ribbon);
    public static final IDataSerializer<SpawnLocationType> SPAWN_LOCATION_TYPE = new BlockedDataSerializer<SpawnLocationType>((buffer, spawnLocationType) -> buffer.writeInt(spawnLocationType.ordinal()), buffer -> SpawnLocationType.values()[buffer.readInt()], spawnLocationType -> spawnLocationType);
    public static final IDataSerializer<EnumBoundingBoxMode> BOUNDING_BOX_MODE = new BlockedDataSerializer<EnumBoundingBoxMode>((buffer, boundingBoxMode) -> buffer.writeInt(boundingBoxMode.ordinal()), buffer -> EnumBoundingBoxMode.values()[buffer.readInt()], boundingBoxMode -> boundingBoxMode);
    public static final IDataSerializer<EnumStatueTextureType> STATUE_TEXTURE_TYPE = new BlockedDataSerializer<EnumStatueTextureType>((buffer, statueTextureType) -> buffer.writeInt(statueTextureType.ordinal()), buffer -> EnumStatueTextureType.values()[buffer.readInt()], statueTextureType -> statueTextureType);
    public static final IDataSerializer<AnimationType> ANIMATION_TYPE = new BlockedDataSerializer<AnimationType>((buffer, animationType) -> buffer.writeInt(animationType.ordinal()), buffer -> AnimationType.values()[buffer.readInt()], animationType -> animationType);
    public static final IDataSerializer<Optional<Color>> OPTIONAL_COLOR = new BlockedDataSerializer<Optional>((buffer, color) -> {
        if (!color.isPresent()) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.writeInt(((Color)color.get()).getRed());
        buffer.writeInt(((Color)color.get()).getGreen());
        buffer.writeInt(((Color)color.get()).getBlue());
        buffer.writeInt(((Color)color.get()).getAlpha());
    }, buffer -> {
        if (!buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new Color(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));
    }, color -> color.map(value -> new Color(value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha())));
    public static final IDataSerializer<Color> COLOR = new BlockedDataSerializer<Color>((buffer, color) -> buffer.writeInt(color.getRGB()), buffer -> new Color(buffer.readInt()), color -> new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
    public static final IDataSerializer<RaidData> RAID_DATA = new BlockedDataSerializer<RaidData>((buffer, raid) -> {
        buffer.writeInt(raid.getDen());
        buffer.writeInt(raid.getStars());
        buffer.writeInt(raid.getSpecies().getDex());
        if (raid.getForm() == null) {
            buffer.func_180714_a(raid.getSpecies().getDefaultForm().getName());
        } else {
            buffer.func_180714_a(raid.getForm().getName());
        }
    }, buffer -> new RaidData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.func_218666_n()), raid -> new RaidData(raid.getDen(), raid.getStars(), raid.getSpecies(), raid.getForm()));
    public static final IDataSerializer<EnumNPCTutorType> NPC_TUTOR_TYPE = new BlockedDataSerializer<EnumNPCTutorType>((buffer, tutorType) -> buffer.writeInt(tutorType.ordinal()), buffer -> EnumNPCTutorType.values()[buffer.readInt()], tutorType -> tutorType);
    public static final IDataSerializer<BaseTrainer> BASE_TRAINER = new BlockedDataSerializer<BaseTrainer>((buffer, trainer) -> buffer.writeInt(trainer.id), buffer -> {
        BaseTrainer byId = ServerNPCRegistry.trainers.getById(buffer.readInt());
        return byId;
    }, trainer -> trainer);
    public static final IDataSerializer<EnumTrainerAI> TRAINER_AI = new BlockedDataSerializer<EnumTrainerAI>((buffer, trainerAI) -> buffer.writeInt(trainerAI.ordinal()), buffer -> EnumTrainerAI.values()[buffer.readInt()], trainerAI -> trainerAI);
    public static final IDataSerializer<PokeBallMode> POKE_BALL_MODE = new BlockedDataSerializer<PokeBallMode>((buffer, pokeBallMode) -> buffer.writeInt(pokeBallMode.ordinal()), buffer -> PokeBallMode.values()[buffer.readInt()], pokeBallMode -> pokeBallMode);
    public static final IDataSerializer<PokeBall> POKE_BALL_TYPE = new BlockedDataSerializer<PokeBall>((buffer, pokeBall) -> buffer.func_180714_a(pokeBall.getName()), buffer -> PokeBallRegistry.getPokeBall(buffer.func_218666_n()).orElse((PokeBall)null), pokeBall -> pokeBall);
    public static final IDataSerializer<EnumBike> BIKE_TYPE = new BlockedDataSerializer<EnumBike>((buffer, bikeType) -> buffer.writeInt(bikeType.ordinal()), buffer -> EnumBike.values()[buffer.readInt()], bikeType -> bikeType);
    public static final IDataSerializer<DyeColor> DYE_COLOR = new BlockedDataSerializer<DyeColor>((buffer, dyeColor) -> buffer.writeInt(dyeColor.ordinal()), buffer -> DyeColor.values()[buffer.readInt()], dyeColor -> dyeColor);
    public static final IDataSerializer<EnumEncounterMode> ENCOUNTER_MODE = new BlockedDataSerializer<EnumEncounterMode>((buffer, encounterMode) -> buffer.writeInt(encounterMode.ordinal()), buffer -> EnumEncounterMode.values()[buffer.readInt()], encounterMode -> encounterMode);
    public static final IDataSerializer<EnumMegaItemsUnlocked> MEGA_ITEM = new BlockedDataSerializer<EnumMegaItemsUnlocked>((buffer, megaItem) -> buffer.writeInt(megaItem.ordinal()), buffer -> EnumMegaItemsUnlocked.values()[buffer.readInt()], megaItem -> megaItem);
    public static final IDataSerializer<EnumOldGenMode> OLD_GEN_MODE = new BlockedDataSerializer<EnumOldGenMode>((buffer, oldGenMode) -> buffer.writeInt(oldGenMode.ordinal()), buffer -> EnumOldGenMode.values()[buffer.readInt()], oldGenMode -> oldGenMode);
    public static final IDataSerializer<BattleAIMode> BATTLE_AI_MODE = new BlockedDataSerializer<BattleAIMode>((buffer, aiMode) -> buffer.writeInt(aiMode.ordinal()), buffer -> BattleAIMode.values()[buffer.readInt()], aiMode -> aiMode);
    public static final IDataSerializer<WoodType> WOOD_TYPE = new BlockedDataSerializer<WoodType>((buffer, woodType) -> buffer.func_180714_a(woodType.func_227048_b_()), buffer -> {
        String name = buffer.func_218666_n();
        return WoodType.func_227046_a_().filter(woodType -> woodType.func_227048_b_().equalsIgnoreCase(name)).findFirst().get();
    }, woodType -> woodType);
    public static final IDataSerializer<EvolutionStage> EVO_STAGE = new BlockedDataSerializer<EvolutionStage>((buffer, evoStage) -> {
        buffer.writeBoolean(evoStage != null);
        if (evoStage != null) {
            buffer.writeByte(evoStage.ordinal());
        }
    }, buffer -> {
        if (!buffer.readBoolean()) {
            return null;
        }
        return EvolutionStage.values()[buffer.readByte()];
    }, evolutionStage -> evolutionStage);
    public static final IDataSerializer<String[]> STRING_ARRAY = new BlockedDataSerializer<String[]>((buffer, list) -> {
        buffer.writeInt(((String[])list).length);
        for (String s : list) {
            buffer.func_180714_a(s);
        }
    }, buffer -> {
        int size = buffer.readInt();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = buffer.func_218666_n();
        }
        return array;
    }, array -> array);
    public static final IDataSerializer<ResourceLocation> RESOURCE_LOCATION = new IDataSerializer<ResourceLocation>(){

        public void write(PacketBuffer buffer, ResourceLocation resourceLocation) {
            buffer.writeBoolean(resourceLocation != null);
            if (resourceLocation != null) {
                buffer.func_192572_a(resourceLocation);
            }
        }

        public ResourceLocation read(PacketBuffer packetBuffer) {
            if (packetBuffer.readBoolean()) {
                return packetBuffer.func_192575_l();
            }
            return null;
        }

        public ResourceLocation copy(ResourceLocation resourceLocation) {
            if (resourceLocation != null) {
                return new ResourceLocation(resourceLocation.toString());
            }
            return null;
        }
    };
    public static final IDataSerializer<Pokerus> POKERUS = new IDataSerializer<Pokerus>(){

        public void write(PacketBuffer buf, Pokerus value) {
            buf.writeShort(value.type.ordinal());
            buf.writeInt(value.secondsSinceInfection);
            buf.writeBoolean(value.announced);
        }

        public Pokerus read(PacketBuffer buf) {
            Pokerus p = new Pokerus(PokerusStrain.values()[buf.readShort()]);
            p.secondsSinceInfection = buf.readInt();
            p.announced = buf.readBoolean();
            return p;
        }

        public DataParameter<Pokerus> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public Pokerus copy(Pokerus value) {
            return value;
        }
    };

    public static void bootstrap() {
    }

    static {
        DataSerializers.func_187189_a(POKEMON_BASE);
        DataSerializers.func_187189_a(GROWTH);
        DataSerializers.func_187189_a(BOSS_MODE);
        DataSerializers.func_187189_a(RIBBON_TYPE);
        DataSerializers.func_187189_a(SPAWN_LOCATION_TYPE);
        DataSerializers.func_187189_a(BOUNDING_BOX_MODE);
        DataSerializers.func_187189_a(ANIMATION_TYPE);
        DataSerializers.func_187189_a(STATUE_TEXTURE_TYPE);
        DataSerializers.func_187189_a(OPTIONAL_COLOR);
        DataSerializers.func_187189_a(COLOR);
        DataSerializers.func_187189_a(RAID_DATA);
        DataSerializers.func_187189_a(NPC_TUTOR_TYPE);
        DataSerializers.func_187189_a(BASE_TRAINER);
        DataSerializers.func_187189_a(TRAINER_AI);
        DataSerializers.func_187189_a(POKE_BALL_MODE);
        DataSerializers.func_187189_a(POKE_BALL_TYPE);
        DataSerializers.func_187189_a(BIKE_TYPE);
        DataSerializers.func_187189_a(DYE_COLOR);
        DataSerializers.func_187189_a(ENCOUNTER_MODE);
        DataSerializers.func_187189_a(MEGA_ITEM);
        DataSerializers.func_187189_a(OLD_GEN_MODE);
        DataSerializers.func_187189_a(BATTLE_AI_MODE);
        DataSerializers.func_187189_a(WOOD_TYPE);
        DataSerializers.func_187189_a(RESOURCE_LOCATION);
        DataSerializers.func_187189_a(POKERUS);
        DataSerializers.func_187189_a(EVO_STAGE);
        DataSerializers.func_187189_a(STRING_ARRAY);
    }
}

