/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.entity.player.ServerPlayerEntity;

public class FormLogRegistry {
    private static final Map<RegistryValue<Species>, LinkedHashMultimap<Integer, PokemonSpecification>> REGISTRY = Maps.newHashMap();

    public static void init() {
        REGISTRY.clear();
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 0, PokemonSpecificationProxy.create("palette:none"), PokemonSpecificationProxy.create("palette:skelly"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 1, PokemonSpecificationProxy.create("palette:calico_orange_white"), PokemonSpecificationProxy.create("palette:calico_orange_white_black"), PokemonSpecificationProxy.create("palette:calico_white_orange"), PokemonSpecificationProxy.create("palette:calico_orange_gold"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 2, PokemonSpecificationProxy.create("palette:orange_twotone"), PokemonSpecificationProxy.create("palette:orange_orca"), PokemonSpecificationProxy.create("palette:orange_dapples"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 3, PokemonSpecificationProxy.create("palette:pink_twotone"), PokemonSpecificationProxy.create("palette:pink_orca"), PokemonSpecificationProxy.create("palette:pink_dapples"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 4, PokemonSpecificationProxy.create("palette:gray_bubbles"), PokemonSpecificationProxy.create("palette:gray_diamonds"), PokemonSpecificationProxy.create("palette:gray_patches"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 5, PokemonSpecificationProxy.create("palette:purple_bubbles"), PokemonSpecificationProxy.create("palette:purple_diamonds"), PokemonSpecificationProxy.create("palette:purple_patches"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 6, PokemonSpecificationProxy.create("palette:apricot_tiger"), PokemonSpecificationProxy.create("palette:apricot_zebra"), PokemonSpecificationProxy.create("palette:apricot_stripes"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 7, PokemonSpecificationProxy.create("palette:brown_tiger"), PokemonSpecificationProxy.create("palette:brown_zebra"), PokemonSpecificationProxy.create("palette:brown_stripes"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 8, PokemonSpecificationProxy.create("palette:orange_forehead"), PokemonSpecificationProxy.create("palette:orange_mask"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 9, PokemonSpecificationProxy.create("palette:black_forehead"), PokemonSpecificationProxy.create("palette:black_mask"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 10, PokemonSpecificationProxy.create("palette:blue_saucy"), PokemonSpecificationProxy.create("palette:blue_raindrops"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 11, PokemonSpecificationProxy.create("palette:violet_saucy"), PokemonSpecificationProxy.create("palette:violet_raindrops"));
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 12, PokemonSpecificationProxy.create("palette:shiny"), PokemonSpecificationProxy.create("palette:roasted"), PokemonSpecificationProxy.create("palette:valencian"));
        FormLogRegistry.createCategory(PixelmonSpecies.SHELLOS, 0, PokemonSpecificationProxy.create("form:east palette:none"), PokemonSpecificationProxy.create("form:east palette:shiny"), PokemonSpecificationProxy.create("form:east palette:gray_bubbles"), PokemonSpecificationProxy.create("form:east palette:purple_bubbles"), PokemonSpecificationProxy.create("form:east palette:violet_saucy"), PokemonSpecificationProxy.create("form:east palette:apricot_saucy"), PokemonSpecificationProxy.create("form:east palette:moons"), PokemonSpecificationProxy.create("form:east palette:golde"));
        FormLogRegistry.createCategory(PixelmonSpecies.SHELLOS, 1, PokemonSpecificationProxy.create("form:west palette:none"), PokemonSpecificationProxy.create("form:west palette:shiny"), PokemonSpecificationProxy.create("form:west palette:gray_diamonds"), PokemonSpecificationProxy.create("form:west palette:purple_diamonds"), PokemonSpecificationProxy.create("form:west palette:brown_stripes"), PokemonSpecificationProxy.create("form:west palette:blue_stripes"), PokemonSpecificationProxy.create("form:west palette:sun"), PokemonSpecificationProxy.create("form:west palette:goldw"));
        FormLogRegistry.createCategory(PixelmonSpecies.CLOBBOPUS, 0, PokemonSpecificationProxy.create("palette:none"), PokemonSpecificationProxy.create("palette:irish"), PokemonSpecificationProxy.create("palette:diamonds"), PokemonSpecificationProxy.create("palette:clubs"), PokemonSpecificationProxy.create("palette:martian"), PokemonSpecificationProxy.create("palette:starry"), PokemonSpecificationProxy.create("palette:yellow_ringed"), PokemonSpecificationProxy.create("palette:red_ringed"), PokemonSpecificationProxy.create("palette:alien"), PokemonSpecificationProxy.create("palette:shiny"));
        FormLogRegistry.createCategory(PixelmonSpecies.SPHEAL, 0, PokemonSpecificationProxy.create("palette:none"), PokemonSpecificationProxy.create("palette:pokeball"), PokemonSpecificationProxy.create("palette:duskball"), PokemonSpecificationProxy.create("palette:loveball"), PokemonSpecificationProxy.create("palette:friendball"), PokemonSpecificationProxy.create("palette:heavyball"), PokemonSpecificationProxy.create("palette:moonball"), PokemonSpecificationProxy.create("palette:premierball"), PokemonSpecificationProxy.create("palette:masterball"), PokemonSpecificationProxy.create("palette:gsball"), PokemonSpecificationProxy.create("palette:shiny"));
        FormLogRegistry.createCategory(PixelmonSpecies.SLUGMA, 0, PokemonSpecificationProxy.create("palette:none"), PokemonSpecificationProxy.create("palette:copper_sulfate"), PokemonSpecificationProxy.create("palette:cupric_chloride"), PokemonSpecificationProxy.create("palette:lithium_chloride"), PokemonSpecificationProxy.create("palette:magnesium_sulfide"), PokemonSpecificationProxy.create("palette:manganese_chloride"), PokemonSpecificationProxy.create("palette:potassium_chloride"), PokemonSpecificationProxy.create("palette:sodium_carbonate"), PokemonSpecificationProxy.create("palette:calcium_carbonate"), PokemonSpecificationProxy.create("palette:shiny"));
    }

    public static Stream<Species> getSpeciesList() {
        return REGISTRY.keySet().stream().map(RegistryValue::getValueUnsafe).sorted();
    }

    public static LinkedHashMultimap<Integer, PokemonSpecification> getFormsForSpecies(Species species) {
        return REGISTRY.getOrDefault(species.getRegistryValue(), (LinkedHashMultimap<Integer, PokemonSpecification>)LinkedHashMultimap.create());
    }

    public static int getFormId(Species species, PokemonSpecification palette) {
        LinkedHashMultimap<Integer, PokemonSpecification> map = FormLogRegistry.getFormsForSpecies(species);
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        return specs.indexOf(palette);
    }

    public static int getFirstIdFromPokemon(Pokemon pokemon) {
        LinkedHashMultimap<Integer, PokemonSpecification> map = FormLogRegistry.getFormsForSpecies(pokemon.getSpecies());
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        for (int i = 0; i < specs.size(); ++i) {
            if (!((PokemonSpecification)specs.get(i)).matches(pokemon)) continue;
            return i;
        }
        return -1;
    }

    public static PokemonSpecification getFormFromId(Species species, int id) {
        LinkedHashMultimap<Integer, PokemonSpecification> map = FormLogRegistry.getFormsForSpecies(species);
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        return (PokemonSpecification)specs.get(id);
    }

    public static void createCategory(RegistryValue<Species> species, int category, PokemonSpecification ... palettes) {
        if (!REGISTRY.containsKey(species)) {
            REGISTRY.put(species, (LinkedHashMultimap<Integer, PokemonSpecification>)LinkedHashMultimap.create());
        }
        Multimap map = (Multimap)REGISTRY.get(species);
        map.putAll((Object)category, (Iterable)Lists.newArrayList((Object[])palettes));
    }

    public static int[] getData(ServerPlayerEntity target, Species species) {
        Map<Short, Short> cells = StorageProxy.getParty((ServerPlayerEntity)target).playerPokedex.seenForms(species);
        int[] data = new int[FormLogRegistry.getFormsForSpecies(species).size()];
        cells.forEach((key, value) -> {
            data[key.shortValue()] = value.shortValue();
        });
        return data;
    }

    public static int[] getMenuData(ServerPlayerEntity playerIn) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(REGISTRY.size());
        FormLogRegistry.getSpeciesList().forEachOrdered(species -> {
            list.add(species.getDex());
            int[] data = FormLogRegistry.getData(playerIn, species);
            list.add(data.length);
            for (int i : data) {
                list.add(i);
            }
        });
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static void assignRandomFish(SpawnActionPokemon spawnPokemon) {
        RegistryValue<Species> species = RandomHelper.getRandomElementFromCollection(REGISTRY.keySet());
        spawnPokemon.pokemon.setSpecies(species, true);
        spawnPokemon.pokemon.initialize(InitializeCategory.SPECIES, InitializeCategory.INTRINSIC);
        spawnPokemon.pokemon.getMoveset().clear();
        ((PokemonSpecification)RandomHelper.getRandomElementFromCollection(REGISTRY.get(species).values())).apply(spawnPokemon.pokemon);
    }
}

