/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RibbonRequirement
extends AbstractPokemonRequirement<Set<String>> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"ribbon", "ribbons"});
    private static final Set<String> NONE = Sets.newLinkedHashSet();
    private Set<String> ribbons;

    public RibbonRequirement() {
        super(KEYS);
    }

    public RibbonRequirement(Set<String> ribbons) {
        this();
        this.ribbons = ribbons;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length < 2) {
            return Collections.singletonList(this.createInstance(NONE));
        }
        LinkedHashSet ribbons = Sets.newLinkedHashSet();
        for (String name : args[1].split(",")) {
            RibbonType ribbonType = RibbonRegistry.getRibbon(name).getValueUnsafe();
            if (ribbonType == null) continue;
            ribbons.add(name);
        }
        if (ribbons.isEmpty()) {
            return Collections.singletonList(this.createInstance(NONE));
        }
        return Collections.singletonList(this.createInstance(ribbons));
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Set<String>> createInstance(Set<String> value) {
        return new RibbonRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        for (Ribbon ribbon : pixelmon.getRibbons()) {
            if (this.ribbons.contains(ribbon.getType().getKey())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        for (String ribbon : this.ribbons) {
            RibbonRegistry.getRibbon(ribbon).ifInitialized(pixelmon::addRibbon);
        }
    }

    @Override
    public Set<String> getValue() {
        return this.ribbons;
    }
}

