/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractBooleanPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class HiddenAbilityRequirement
extends AbstractBooleanPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"hiddenability", "ha"});

    public HiddenAbilityRequirement() {
        super(KEYS);
    }

    public HiddenAbilityRequirement(boolean value) {
        super(KEYS, value);
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Boolean> createInstance(Boolean value) {
        return new HiddenAbilityRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        for (Ability hiddenAbility : pixelmon.getForm().getAbilities().getHiddenAbilities()) {
            if (hiddenAbility == null || !pixelmon.getAbilityName().equalsIgnoreCase(hiddenAbility.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (pixelmon.getForm().getAbilities().hasHiddenAbilities()) {
            pixelmon.setAbility(pixelmon.getForm().getAbilities().getRandomHiddenAbility());
            pixelmon.overrideAbilitySlot();
        }
    }
}

