/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractBooleanPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.Set;

public class CanMegaEvolveRequirement
extends AbstractBooleanPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"canmegaevo", "canmega", "canmegaevolve"});

    public CanMegaEvolveRequirement() {
        super(KEYS);
    }

    public CanMegaEvolveRequirement(boolean value) {
        super(KEYS, value);
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Boolean> createInstance(Boolean value) {
        return new CanMegaEvolveRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (pixelmon.hasFlag("unmegaevo")) {
            return false;
        }
        if (pixelmon.getSpecies().is(PixelmonSpecies.RAYQUAZA)) {
            return pixelmon.getMoveset().hasAttack(AttackRegistry.DRAGON_ASCENT);
        }
        if (pixelmon.getSpecies().is(PixelmonSpecies.GRENINJA)) {
            return pixelmon.getForm().isForm("battle_bond");
        }
        if (pixelmon.getHeldItemAsItemHeld() == NoItem.noItem) {
            return false;
        }
        if (pixelmon.getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.megaStone) {
            return pixelmon.getForm().hasMegaForm();
        }
        return false;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (this.value) {
            pixelmon.removeFlag("unmegaevo");
        } else {
            pixelmon.addFlag("unmegaevo");
        }
    }
}

