/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import fudge.notenoughcrashes.NecConfig;
import fudge.notenoughcrashes.StateManager;
import fudge.notenoughcrashes.gui.CrashScreen;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import fudge.notenoughcrashes.utils.GlUtil;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InGameCatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes In Game Crashes");
    private static int clientCrashCount = 0;
    private static int serverCrashCount = 0;

    public static void handleClientCrash(CrashReport report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.resetStates();
        boolean reported = report.func_71505_b() instanceof ReportedException;
        LOGGER.fatal(reported ? "Reported" : "Unreported exception thrown!", report.func_71505_b());
        InGameCatcher.displayCrashScreen(report, ++clientCrashCount, true);
        InGameCatcher.getClient().func_99999_d();
    }

    private static void resetStates() {
        GlUtil.resetState();
        StateManager.resetStates();
        InGameCatcher.resetModState();
        InGameCatcher.resetCriticalGameState();
    }

    public static void cleanupBeforeMinecraft(Queue<Runnable> renderTaskQueue) {
        if (InGameCatcher.getClient().func_147114_u() != null) {
            InGameCatcher.getClient().func_147114_u().func_147298_b().func_150718_a((ITextComponent)new StringTextComponent(String.format("[%s] Client crashed", "Not Enough Crashes")));
        }
        InGameCatcher.getClient().func_213231_b((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("menu.savingLevel")));
        renderTaskQueue.clear();
    }

    private static void resetCriticalGameState() {
        Minecraft client = InGameCatcher.getClient();
        client.field_71439_g = null;
        client.field_71441_e = null;
    }

    private static void resetModState() {
    }

    public static void handleServerCrash(CrashReport report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.displayCrashScreen(report, ++serverCrashCount, false);
    }

    private static Minecraft getClient() {
        return Minecraft.func_71410_x();
    }

    public static void addInfoToCrash(CrashReport report) {
        report.func_85056_g().func_189529_a("Client Crashes Since Restart", () -> String.valueOf(clientCrashCount));
        report.func_85056_g().func_189529_a("Integrated Server Crashes Since Restart", () -> String.valueOf(serverCrashCount));
    }

    private static void displayCrashScreen(CrashReport report, int crashCount, boolean clientCrash) {
        try {
            if (EntryPointCatcher.crashedDuringStartup()) {
                throw new IllegalStateException("Could not initialize startup crash screen");
            }
            if (crashCount > NecConfig.instance().crashLimit) {
                throw new IllegalStateException("The game has crashed an excessive amount of times");
            }
            CrashUtils.outputReport(report, clientCrash);
            InGameCatcher.getClient().field_71474_y.field_74330_P = false;
            InGameCatcher.getClient().field_71456_v.func_146158_b().func_146231_a(true);
            InGameCatcher.getClient().func_147108_a((Screen)new CrashScreen(report));
        }
        catch (Throwable t) {
            LOGGER.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            Minecraft.func_71377_b((CrashReport)report);
            System.exit(report.func_71497_f() != null ? -1 : -2);
        }
    }
}

