/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.world;

import java.lang.ref.WeakReference;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DefaultWithNameUncaughtExceptionHandler;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.world.ThreadDumper;

public class IntegratedWatchdog
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private final WeakReference<MinecraftServer> server;
    private static final long MAX_TICK_DELTA = 40000L;

    public IntegratedWatchdog(MinecraftServer server) {
        this.server = new WeakReference<MinecraftServer>(server);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultWithNameUncaughtExceptionHandler(LOGGER));
        this.setName("ModernFix integrated server watchdog");
    }

    @Override
    public void run() {
        MinecraftServer server;
        while ((server = (MinecraftServer)this.server.get()) != null && server.func_71278_l()) {
            long nextTick = server.func_211150_az();
            long curTime = Util.func_211177_b();
            long delta = curTime - nextTick;
            if (delta > 40000L) {
                LOGGER.error("A single server tick has taken {}, more than {} milliseconds", (Object)delta, (Object)40000L);
                LOGGER.error(ThreadDumper.obtainThreadDump());
                nextTick = 0L;
                curTime = 0L;
            }
            server = null;
            try {
                Thread.sleep(nextTick + 40000L - curTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }
}

