/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.shadow.mixinextras.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.refmap.IMixinContext;

public class CompatibilityHelper {
    private static final Constructor<InvalidInjectionException> INVALID_INJECTION_EXCEPTION_CONSTRUCTOR = Arrays.stream(InvalidInjectionException.class.getConstructors()).filter(it -> {
        Class<?>[] parameters = it.getParameterTypes();
        return parameters.length == 2 && parameters[0].isAssignableFrom(InjectionInfo.class) && parameters[1] == String.class;
    }).findAny().orElse(null);
    private static final Method INJECTION_INFO_GET_MIXIN_METHOD = Arrays.stream(InjectionInfo.class.getMethods()).filter(it -> it.getParameterTypes().length == 0 && it.getReturnType() == IMixinContext.class && it.getName().startsWith("get")).findAny().orElse(null);
    private static final Constructor<LocalVariableDiscriminator.Context> LVT_CONTEXT_CONSTRUCTOR = Arrays.stream(LocalVariableDiscriminator.Context.class.getConstructors()).filter(it -> {
        int offset;
        Class<?>[] parameters = it.getParameterTypes();
        int n = parameters.length == 4 ? 0 : (offset = parameters.length == 5 ? 1 : -1);
        if (offset == -1) {
            return false;
        }
        return parameters[offset] == Type.class && parameters[offset + 1] == Boolean.TYPE && parameters[offset + 2] == Target.class && parameters[offset + 3] == AbstractInsnNode.class;
    }).findAny().orElse(null);
    private static final Method INJECTION_INFO_PRE_INJECT_METHOD = Arrays.stream(InjectionInfo.class.getMethods()).filter(it -> it.getName().equals("preInject")).findFirst().orElse(null);

    public static RuntimeException makeInvalidInjectionException(InjectionInfo info, String message) {
        try {
            return (RuntimeException)((Object)INVALID_INJECTION_EXCEPTION_CONSTRUCTOR.newInstance(info, message));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static IMixinContext getMixin(InjectionInfo info) {
        try {
            return (IMixinContext)INJECTION_INFO_GET_MIXIN_METHOD.invoke((Object)info, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalVariableDiscriminator.Context makeLvtContext(InjectionInfo info, Type returnType, boolean argsOnly, Target target, AbstractInsnNode node) {
        try {
            if (LVT_CONTEXT_CONSTRUCTOR.getParameterCount() == 4) {
                return LVT_CONTEXT_CONSTRUCTOR.newInstance(returnType, argsOnly, target, node);
            }
            return LVT_CONTEXT_CONSTRUCTOR.newInstance(info, returnType, argsOnly, target, node);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void preInject(InjectionInfo info) {
        try {
            INJECTION_INFO_PRE_INJECT_METHOD.invoke((Object)info, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

