/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources.supermartijncore;

import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientRegistrationHandler.class})
@RequiresMod(value="supermartijn642corelib")
@ClientOnlyMixin
public class ClientRegistrationHandlerMixin {
    @Shadow(remap=false)
    @Final
    private List<Pair<Supplier<Stream<ResourceLocation>>, Function<IBakedModel, IBakedModel>>> modelOverwrites;
    private Map<ResourceLocation, Function<IBakedModel, IBakedModel>> modelOverwritesByLocation = new Object2ObjectOpenHashMap();

    @Redirect(method={"handleModelBakeEvent"}, at=@At(value="FIELD", target="Lcom/supermartijn642/core/registry/ClientRegistrationHandler;modelOverwrites:Ljava/util/List;"), remap=false)
    private List<?> skipModelOverwrites(ClientRegistrationHandler h) {
        this.modelOverwritesByLocation.clear();
        for (Pair<Supplier<Stream<ResourceLocation>>, Function<IBakedModel, IBakedModel>> pair : this.modelOverwrites) {
            Stream locationStream = (Stream)((Supplier)pair.left()).get();
            Function swapper = (Function)pair.right();
            locationStream.forEach(l -> this.modelOverwritesByLocation.put((ResourceLocation)l, swapper));
        }
        return Collections.emptyList();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void registerDynBake(String modid, CallbackInfo ci) {
        ModernFixClient.CLIENT_INTEGRATIONS.add(new ModernFixClientIntegration(){

            @Override
            public IBakedModel onBakedModelLoad(ResourceLocation location, IUnbakedModel baseModel, IBakedModel originalModel, IModelTransform state, ModelBakery bakery) {
                Function replacer = (Function)ClientRegistrationHandlerMixin.this.modelOverwritesByLocation.get(location);
                if (replacer != null) {
                    return (IBakedModel)replacer.apply(originalModel);
                }
                return originalModel;
            }
        });
    }
}

