/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources.ctm;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.chisel.ctm.CTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureMetadataHandler;

@Mixin(value={TextureMetadataHandler.class})
@RequiresMod(value="ctm")
@ClientOnlyMixin
public abstract class TextureMetadataHandlerMixin
implements ModernFixClientIntegration {
    @Shadow
    @Nonnull
    protected abstract IBakedModel wrap(ResourceLocation var1, IUnbakedModel var2, IBakedModel var3, ModelLoader var4) throws IOException;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void subscribeDynamic(CallbackInfo ci) {
        ModernFixClient.CLIENT_INTEGRATIONS.add(this);
    }

    @Inject(method={"onModelBake"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void noIteration(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public IBakedModel onBakedModelLoad(ResourceLocation rl, IUnbakedModel rootModel, IBakedModel baked, IModelTransform state, ModelBakery bakery) {
        if (!(baked instanceof AbstractCTMBakedModel) && !baked.func_188618_c()) {
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = false;
            HashSet errors = new HashSet();
            while (!shouldWrap && !dependencies.isEmpty()) {
                IUnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : bakery.func_209597_a(dep);
                }
                catch (Exception e) {
                    continue;
                }
                Collection textures = model.func_225614_a_(arg_0 -> ((ModelBakery)bakery).func_209597_a(arg_0), errors);
                Collection newDependencies = model.func_187965_e();
                for (RenderMaterial tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata((ResourceLocation)ResourceUtil.spriteToAbsolute((ResourceLocation)tex.func_229313_b_()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                }
                for (ResourceLocation newDep : newDependencies) {
                    if (!seenModels.add(newDep)) continue;
                    dependencies.push(newDep);
                }
            }
            if (shouldWrap) {
                try {
                    baked = this.wrap(rl, rootModel, baked, (ModelLoader)bakery);
                    dependencies.clear();
                }
                catch (IOException e) {
                    CTM.logger.error("Could not wrap model " + rl + ". Aborting...", (Throwable)e);
                }
            }
        }
        return baked;
    }
}

