/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources.ctm;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.api.helpers.ModelHelpers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.CTMPackReloadListener;

@Mixin(value={CTMPackReloadListener.class})
@RequiresMod(value="ctm")
@ClientOnlyMixin
public abstract class CTMPackReloadListenerMixin
implements ModernFixClientIntegration {
    @Shadow(remap=false)
    @Final
    private static Map<IRegistryDelegate<Block>, Predicate<RenderType>> blockRenderChecks;
    private static Map<IRegistryDelegate<Block>, Predicate<RenderType>> renderCheckOverrides;
    private static Predicate<RenderType> DEFAULT_PREDICATE;

    @Shadow
    protected abstract Predicate<RenderType> getLayerCheck(BlockState var1, IBakedModel var2);

    @Shadow
    protected abstract Predicate<RenderType> getExistingRenderCheck(Block var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        ModernFixClient.CLIENT_INTEGRATIONS.add(this);
    }

    @Overwrite(remap=false)
    private void refreshLayerHacks() {
        renderCheckOverrides.clear();
        if (blockRenderChecks.isEmpty()) {
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                Predicate<RenderType> original = this.getExistingRenderCheck(block);
                if (original == null) {
                    original = DEFAULT_PREDICATE;
                }
                blockRenderChecks.put((IRegistryDelegate<Block>)block.delegate, original);
                RenderTypeLookup.setRenderLayer((Block)block, type -> this.useOverrideIfPresent((IRegistryDelegate<Block>)block.delegate, (RenderType)type));
            }
        }
    }

    private boolean useOverrideIfPresent(IRegistryDelegate<Block> delegate, RenderType type) {
        Predicate<RenderType> override = renderCheckOverrides.get(delegate);
        if (override == null) {
            override = blockRenderChecks.get(delegate);
        }
        return override.test(type);
    }

    @Override
    public IBakedModel onBakedModelLoad(ResourceLocation location, IUnbakedModel baseModel, IBakedModel originalModel, IModelTransform modelState, ModelBakery bakery) {
        ImmutableList<BlockState> allStates;
        if (!(location instanceof ModelResourceLocation)) {
            return originalModel;
        }
        if (!(originalModel instanceof AbstractCTMBakedModel || originalModel instanceof WeightedBakedModel || originalModel instanceof MultipartBakedModel)) {
            return originalModel;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(location.func_110624_b(), location.func_110623_a()));
        if (block == null || block == Blocks.field_150350_a || renderCheckOverrides.containsKey(block.delegate)) {
            return originalModel;
        }
        try {
            allStates = ModelHelpers.getBlockStateForLocation((StateContainer<Block, BlockState>)block.func_176194_O(), (ModelResourceLocation)location);
        }
        catch (RuntimeException e) {
            ModernFix.LOGGER.error("Couldn't get state for MRL " + location, (Throwable)e);
            return originalModel;
        }
        for (BlockState state : allStates) {
            Predicate<RenderType> newPredicate = this.getLayerCheck(state, originalModel);
            if (newPredicate == null) continue;
            renderCheckOverrides.put((IRegistryDelegate<Block>)block.delegate, newPredicate);
            return originalModel;
        }
        return originalModel;
    }

    static {
        renderCheckOverrides = new ConcurrentHashMap<IRegistryDelegate<Block>, Predicate<RenderType>>();
        DEFAULT_PREDICATE = type -> type == RenderType.func_228639_c_();
    }
}

