/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.dynamicresources.UVController;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;

public class ModelBakeryHelpers {
    public static final int MAX_BAKED_MODEL_COUNT = 10000;
    public static final int MAX_UNBAKED_MODEL_COUNT = 10000;
    public static final int MAX_MODEL_LIFETIME_SECS = 300;
    private static final int ERROR_THRESHOLD = 200;
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static String[] getExtraTextureFolders() {
        return new String[]{"attachment", "bettergrass", "block", "blocks", "cape", "entity/bed", "entity/chest", "item", "items", "model", "models", "part", "pipe", "ropebridge", "runes", "solid_block", "spell_effect", "spell_projectile"};
    }

    private static JsonElement parseStream(InputStream stream) {
        JsonParser parser = new JsonParser();
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        jsonReader.setLenient(true);
        return parser.parse(jsonReader);
    }

    private static void gatherAdditionalViaManualScan(List<IResourcePack> untrustedPacks, Set<ResourceLocation> knownLocations, Collection<ResourceLocation> uncertainLocations, String filePrefix) {
        if (untrustedPacks.size() > 0) {
            FallbackResourceManager frm = new FallbackResourceManager(ResourcePackType.CLIENT_RESOURCES, "dummy");
            for (int i = untrustedPacks.size() - 1; i >= 0; --i) {
                frm.func_199021_a(untrustedPacks.get(i));
            }
            for (ResourceLocation blockstate : uncertainLocations) {
                if (knownLocations.contains(blockstate)) continue;
                ResourceLocation fileLocation = new ResourceLocation(blockstate.func_110624_b(), filePrefix + blockstate.func_110623_a() + ".json");
                try (IResource resource = frm.func_199002_a(fileLocation);){
                    knownLocations.add(blockstate);
                }
                catch (IOException | RuntimeException exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logOrSuppressError(Object2IntOpenHashMap<String> suppressionMap, String type, ResourceLocation location, Throwable e) {
        int numErrors;
        Object2IntOpenHashMap<String> object2IntOpenHashMap = suppressionMap;
        synchronized (object2IntOpenHashMap) {
            numErrors = suppressionMap.computeInt((Object)location.func_110624_b(), (k, oldVal) -> oldVal == null ? 1 : oldVal + 1);
        }
        if (numErrors <= 200) {
            ModernFix.LOGGER.error("Error reading {} {}: {}", (Object)type, (Object)location, (Object)e);
        }
    }

    private static void checkFallbacks(SimpleReloadableResourceManager manager, List<IResourcePack> resourcePackList) {
        ReferenceOpenHashSet knownPacks = new ReferenceOpenHashSet(resourcePackList);
        Map namespacedMap = manager.field_199014_c;
        namespacedMap.values().stream().flatMap(FallbackResourceManager::func_230232_b_).forEach(arg_0 -> ModelBakeryHelpers.lambda$checkFallbacks$1((ReferenceSet)knownPacks, resourcePackList, arg_0));
    }

    public static void gatherModelMaterials(IResourceManager manager, Predicate<IResourcePack> isTrustedPack, Set<RenderMaterial> materialSet, Set<ResourceLocation> blockStateFiles, Set<ResourceLocation> modelFiles, IUnbakedModel missingModel, Function<JsonElement, BlockModel> modelDeserializer, Function<ResourceLocation, IUnbakedModel> bakeryModelGetter) {
        if (!ModernFixPlatformHooks.INSTANCE.isLoadingNormally()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object2IntOpenHashMap blockstateErrors = new Object2IntOpenHashMap();
        ArrayList<IResourcePack> allPackResources = new ArrayList<IResourcePack>(manager.func_230232_b_().collect(Collectors.toList()));
        if (manager instanceof SimpleReloadableResourceManager) {
            ModelBakeryHelpers.checkFallbacks((SimpleReloadableResourceManager)manager, allPackResources);
        }
        Collections.reverse(allPackResources);
        ObjectOpenHashSet allAvailableModels = new ObjectOpenHashSet();
        ObjectOpenHashSet allAvailableStates = new ObjectOpenHashSet();
        for (IResourcePack pack2 : allPackResources) {
            try {
                InputStream stream = pack2.func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("modernfix", "dummy.json"));
                if (stream == null) continue;
                stream.close();
            }
            catch (Exception stream) {}
        }
        allPackResources.removeIf(pack -> {
            for (String namespace : pack.func_195759_a(ResourcePackType.CLIENT_RESOURCES)) {
                Collection allBlockstates = pack.func_225637_a_(ResourcePackType.CLIENT_RESOURCES, namespace, "blockstates", Integer.MAX_VALUE, p -> p.endsWith(".json"));
                for (ResourceLocation blockstate : allBlockstates) {
                    allAvailableStates.add((Object)new ResourceLocation(blockstate.func_110624_b(), blockstate.func_110623_a().replaceFirst("blockstates/", "").replace(".json", "")));
                }
                Collection allModels = pack.func_225637_a_(ResourcePackType.CLIENT_RESOURCES, namespace, "models", Integer.MAX_VALUE, p -> p.endsWith(".json"));
                for (ResourceLocation blockstate : allModels) {
                    allAvailableModels.add((Object)new ResourceLocation(blockstate.func_110624_b(), blockstate.func_110623_a().replaceFirst("models/", "").replace(".json", "")));
                }
            }
            if (!isTrustedPack.test((IResourcePack)pack)) {
                ModernFix.LOGGER.debug("Pack with class {} needs manual scan", (Object)pack.getClass().getName());
                return false;
            }
            return true;
        });
        ModelBakeryHelpers.gatherAdditionalViaManualScan(allPackResources, (Set<ResourceLocation>)allAvailableStates, blockStateFiles, "blockstates/");
        blockStateFiles.retainAll((Collection<?>)allAvailableStates);
        allAvailableStates.clear();
        allAvailableStates.trim();
        ConcurrentLinkedQueue blockStateLoadedFiles = new ConcurrentLinkedQueue();
        ArrayList<CompletableFuture<Void>> blockStateData = new ArrayList<CompletableFuture<Void>>();
        for (ResourceLocation blockstate : blockStateFiles) {
            List resources;
            block32: {
                ResourceLocation fileLocation = new ResourceLocation(blockstate.func_110624_b(), "blockstates/" + blockstate.func_110623_a() + ".json");
                try {
                    resources = manager.func_199004_b(fileLocation);
                    if (resources.isEmpty()) {
                    }
                    break block32;
                }
                catch (IOException iOException) {
                    ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", blockstate, iOException);
                }
                continue;
            }
            blockStateData.add(CompletableFuture.runAsync(() -> {
                try {
                    for (IResource resource : resources) {
                        try {
                            blockStateLoadedFiles.add(Pair.of((Object)blockstate, (Object)ModelBakeryHelpers.parseStream(resource.func_199027_b())));
                        }
                        catch (JsonParseException e) {
                            ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", blockstate, e);
                        }
                        finally {
                            resource.close();
                        }
                    }
                }
                catch (IOException e) {
                    ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", blockstate, e);
                }
            }, ModernFix.resourceReloadExecutor()));
        }
        blockStateFiles = null;
        CompletableFuture.allOf(blockStateData.toArray(new CompletableFuture[0])).join();
        for (Pair pair : blockStateLoadedFiles) {
            if (pair.getSecond() == null) continue;
            try {
                JsonObject obj = ((JsonElement)pair.getSecond()).getAsJsonObject();
                if (obj.has("variants")) {
                    JsonObject eachVariant = obj.getAsJsonObject("variants");
                    for (Map.Entry entry2 : eachVariant.entrySet()) {
                        List<Object> variantModels;
                        JsonElement variantData = (JsonElement)entry2.getValue();
                        if (variantData.isJsonArray()) {
                            variantModels = new ArrayList();
                            for (JsonElement jsonElement : variantData.getAsJsonArray()) {
                                variantModels.add(jsonElement.getAsJsonObject());
                            }
                        } else {
                            variantModels = Collections.singletonList(variantData.getAsJsonObject());
                        }
                        for (JsonObject jsonObject : variantModels) {
                            modelFiles.add(new ResourceLocation(jsonObject.get("model").getAsString()));
                        }
                    }
                    continue;
                }
                JsonArray multipartData = obj.get("multipart").getAsJsonArray();
                for (JsonElement element : multipartData) {
                    List<Object> applyObjects;
                    JsonObject self = element.getAsJsonObject();
                    JsonElement apply = self.get("apply");
                    if (apply.isJsonArray()) {
                        applyObjects = new ArrayList();
                        for (JsonElement jsonElement : apply.getAsJsonArray()) {
                            applyObjects.add(jsonElement.getAsJsonObject());
                        }
                    } else {
                        applyObjects = Collections.singletonList(apply.getAsJsonObject());
                    }
                    for (JsonObject jsonObject : applyObjects) {
                        modelFiles.add(new ResourceLocation(jsonObject.get("model").getAsString()));
                    }
                }
            }
            catch (RuntimeException e) {
                ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "blockstate", (ResourceLocation)pair.getFirst(), e);
            }
        }
        blockstateErrors.object2IntEntrySet().forEach(entry -> {
            if (entry.getIntValue() > 200) {
                ModernFix.LOGGER.error("Suppressed additional {} blockstate errors for domain {}", (Object)entry.getIntValue(), entry.getKey());
            }
        });
        blockstateErrors.clear();
        blockStateData = null;
        blockStateLoadedFiles.clear();
        modelFiles.addAll((Collection<ResourceLocation>)allAvailableModels);
        ModelBakeryHelpers.gatherAdditionalViaManualScan(allPackResources, (Set<ResourceLocation>)allAvailableModels, modelFiles, "models/");
        modelFiles.retainAll((Collection<?>)allAvailableModels);
        allAvailableModels.clear();
        allAvailableModels.trim();
        HashMap<Object, BlockModel> basicModels = new HashMap<Object, BlockModel>();
        basicModels.put(ModelBakery.field_177604_a, (BlockModel)missingModel);
        basicModels.put(new ResourceLocation("builtin/generated"), ModelBakery.field_177606_o);
        basicModels.put(new ResourceLocation("builtin/entity"), ModelBakery.field_177616_r);
        LinkedHashSet errorSet = Sets.newLinkedHashSet();
        while (modelFiles.size() > 0) {
            ArrayList<CompletableFuture<Pair>> modelBytes = new ArrayList<CompletableFuture<Pair>>();
            for (ResourceLocation resourceLocation : modelFiles) {
                if (basicModels.containsKey(resourceLocation)) continue;
                ResourceLocation fileLocation = new ResourceLocation(resourceLocation.func_110624_b(), "models/" + resourceLocation.func_110623_a() + ".json");
                modelBytes.add(CompletableFuture.supplyAsync(() -> {
                    Pair pair;
                    block8: {
                        IResource resource = manager.func_199002_a(fileLocation);
                        try {
                            pair = Pair.of((Object)model, (Object)ModelBakeryHelpers.parseStream(resource.func_199027_b()));
                            if (resource == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (resource != null) {
                                    try {
                                        resource.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (JsonParseException | IOException e) {
                                ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "model", fileLocation, e);
                                return Pair.of((Object)fileLocation, null);
                            }
                        }
                        resource.close();
                    }
                    return pair;
                }, ModernFix.resourceReloadExecutor()));
            }
            modelFiles.clear();
            CompletableFuture.allOf(modelBytes.toArray(new CompletableFuture[0])).join();
            UVController.useDummyUv.set(Boolean.TRUE);
            for (CompletableFuture completableFuture : modelBytes) {
                Pair pair = (Pair)completableFuture.join();
                try {
                    if (pair.getSecond() != null) {
                        BlockModel model = modelDeserializer.apply((JsonElement)pair.getSecond());
                        model.field_178317_b = ((ResourceLocation)pair.getFirst()).toString();
                        modelFiles.addAll(model.func_187965_e());
                        basicModels.put((ResourceLocation)pair.getFirst(), model);
                        continue;
                    }
                }
                catch (Throwable e) {
                    ModelBakeryHelpers.logOrSuppressError((Object2IntOpenHashMap<String>)blockstateErrors, "model", (ResourceLocation)pair.getFirst(), e);
                }
                basicModels.put((ResourceLocation)pair.getFirst(), (BlockModel)missingModel);
            }
            UVController.useDummyUv.set(Boolean.FALSE);
        }
        blockstateErrors.object2IntEntrySet().forEach(entry -> {
            if (entry.getIntValue() > 200) {
                ModernFix.LOGGER.error("Suppressed additional {} model errors for domain {}", (Object)entry.getIntValue(), entry.getKey());
            }
        });
        blockstateErrors.clear();
        modelFiles = null;
        Function<ResourceLocation, IUnbakedModel> modelGetter = loc -> {
            IUnbakedModel m = (IUnbakedModel)basicModels.get(loc);
            return m != null ? m : (IUnbakedModel)bakeryModelGetter.apply((ResourceLocation)loc);
        };
        for (BlockModel blockModel : basicModels.values()) {
            try {
                materialSet.addAll(blockModel.func_225614_a_(modelGetter, (Set)errorSet));
            }
            catch (Throwable e) {
                ModernFix.LOGGER.error("Model {} threw error while getting materials", (Object)blockModel.field_178317_b, (Object)e);
            }
        }
        stopwatch.stop();
        ModernFix.LOGGER.info("Resolving model textures took " + stopwatch);
    }

    private static <T extends Comparable<T>, V extends T> BlockState setPropertyGeneric(BlockState state, Property<T> prop, Object o) {
        return (BlockState)state.func_206870_a(prop, (Comparable)o);
    }

    private static <T extends Comparable<T>> T getValueHelper(Property<T> property, String value) {
        return (T)property.func_185929_b(value).orElse(null);
    }

    public static ImmutableList<BlockState> getBlockStatesForMRL(StateContainer<Block, BlockState> stateDefinition, ModelResourceLocation location) {
        if (Objects.equals(location.func_177518_c(), "inventory")) {
            return ImmutableList.of();
        }
        HashSet<Property> fixedProperties = new HashSet<Property>();
        BlockState fixedState = (BlockState)stateDefinition.func_177621_b();
        for (String s : COMMA_SPLITTER.split((CharSequence)location.func_177518_c())) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            Property property = stateDefinition.func_185920_a(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object value = ModelBakeryHelpers.getValueHelper(property, s2);
                if (value == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + property.func_177700_c());
                }
                fixedState = ModelBakeryHelpers.setPropertyGeneric(fixedState, property, value);
                fixedProperties.add(property);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        if (fixedProperties.size() == stateDefinition.func_177623_d().size()) {
            return ImmutableList.of((Object)fixedState);
        }
        ArrayList anyProperties = new ArrayList(stateDefinition.func_177623_d());
        anyProperties.removeAll(fixedProperties);
        ArrayList<BlockState> finalList = new ArrayList<BlockState>();
        finalList.add(fixedState);
        for (Property property : anyProperties) {
            ArrayList<BlockState> newPermutations = new ArrayList<BlockState>();
            for (BlockState state : finalList) {
                for (Comparable value : property.func_177700_c()) {
                    newPermutations.add(ModelBakeryHelpers.setPropertyGeneric(state, property, value));
                }
            }
            finalList = newPermutations;
        }
        return ImmutableList.copyOf(finalList);
    }

    public static ModernFixClientIntegration bakedModelWrapper(final BiFunction<ResourceLocation, Pair<IUnbakedModel, IBakedModel>, IBakedModel> consumer) {
        return new ModernFixClientIntegration(){

            @Override
            public IBakedModel onBakedModelLoad(ResourceLocation location, IUnbakedModel baseModel, IBakedModel originalModel, IModelTransform state, ModelBakery bakery) {
                return (IBakedModel)consumer.apply(location, Pair.of((Object)baseModel, (Object)originalModel));
            }
        };
    }

    private static /* synthetic */ void lambda$checkFallbacks$1(ReferenceSet knownPacks, List resourcePackList, IResourcePack pack) {
        if (knownPacks.add((Object)pack)) {
            ModernFix.LOGGER.debug("Injecting unlisted pack '{}': {}", (Object)pack.func_195762_a(), (Object)pack.getClass().getName());
            resourcePackList.add(pack);
        }
    }
}

