/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.core.config;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.IgnoreOutsideDev;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.core.config.OptionCategories;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixin;

public class ModernFixEarlyConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"ModernFixConfig");
    private final Map<String, Option> options = new HashMap<String, Option>();
    private final Multimap<String, Option> optionsByCategory = HashMultimap.create();
    private static final boolean ALLOW_OVERRIDE_OVERRIDES = Boolean.getBoolean("modernfix.unsupported.allowOverriding");
    public static final boolean OPTIFINE_PRESENT;
    private File configFile;
    private static final String MIXIN_DESC;
    private static final String MIXIN_CLIENT_ONLY_DESC;
    private static final String MIXIN_REQUIRES_MOD_DESC;
    private static final String MIXIN_DEV_ONLY_DESC;
    private static final Pattern PLATFORM_PREFIX;
    private final Set<String> mixinOptions = new ObjectOpenHashSet();
    private final Map<String, String> mixinsMissingMods = new Object2ObjectOpenHashMap();
    public static boolean isFabric;
    private static final boolean shouldReplaceSearchTrees;
    private static final boolean isDevEnv;
    private static final ImmutableMap<String, Boolean> DEFAULT_SETTING_OVERRIDES;

    private static boolean modPresent(String modId) {
        if (modId.equals("optifine")) {
            return OPTIFINE_PRESENT;
        }
        return ModernFixPlatformHooks.INSTANCE.modPresent(modId);
    }

    public static String sanitize(String mixinClassName) {
        return PLATFORM_PREFIX.matcher(mixinClassName).replaceFirst("");
    }

    public Map<String, String> getPermanentlyDisabledMixins() {
        return this.mixinsMissingMods;
    }

    private void scanForAndBuildMixinOptions() {
        ImmutableList configFiles = ImmutableList.of((Object)"modernfix-common.mixins.json", (Object)"modernfix-fabric.mixins.json", (Object)"modernfix-forge.mixins.json");
        ArrayList<String> mixinPaths = new ArrayList<String>();
        for (String configFile : configFiles) {
            InputStream stream = ModernFixEarlyConfig.class.getClassLoader().getResourceAsStream(configFile);
            if (stream == null) continue;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                JsonObject configObject = (JsonObject)new JsonParser().parse((Reader)reader);
                JsonArray mixinList = configObject.getAsJsonArray("mixins");
                String packageName = configObject.get("package").getAsString().replace('.', '/');
                for (JsonElement mixin : mixinList) {
                    mixinPaths.add(packageName + "/" + mixin.getAsString().replace('.', '/') + ".class");
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.error("Error loading config " + configFile, e);
            }
        }
        Splitter dotSplitter = Splitter.on((char)'.');
        for (String mixinPath : mixinPaths) {
            try {
                InputStream stream = ModernFixEarlyConfig.class.getClassLoader().getResourceAsStream(mixinPath);
                try {
                    ClassReader reader = new ClassReader(stream);
                    ClassNode node = new ClassNode();
                    reader.accept((ClassVisitor)node, 7);
                    if (node.invisibleAnnotations == null) {
                        return;
                    }
                    boolean isMixin = false;
                    boolean isClientOnly = false;
                    boolean requiredModPresent = true;
                    boolean isDevOnly = false;
                    String requiredModId = "";
                    block18: for (AnnotationNode annotation : node.invisibleAnnotations) {
                        if (Objects.equals(annotation.desc, MIXIN_DESC)) {
                            isMixin = true;
                            continue;
                        }
                        if (Objects.equals(annotation.desc, MIXIN_CLIENT_ONLY_DESC)) {
                            isClientOnly = true;
                            continue;
                        }
                        if (Objects.equals(annotation.desc, MIXIN_REQUIRES_MOD_DESC)) {
                            for (int i = 0; i < annotation.values.size(); i += 2) {
                                if (!annotation.values.get(i).equals("value")) continue;
                                String modId = (String)annotation.values.get(i + 1);
                                if (modId == null) continue block18;
                                requiredModPresent = modId.startsWith("!") ? !ModernFixEarlyConfig.modPresent(modId.substring(1)) : ModernFixEarlyConfig.modPresent(modId);
                                requiredModId = modId;
                                continue block18;
                            }
                            continue;
                        }
                        if (!Objects.equals(annotation.desc, MIXIN_DEV_ONLY_DESC)) continue;
                        isDevOnly = true;
                    }
                    if (!isMixin || isDevOnly && !ModernFixPlatformHooks.INSTANCE.isDevEnv()) continue;
                    String mixinClassName = ModernFixEarlyConfig.sanitize(node.name.replace('/', '.')).replace("org.embeddedt.modernfix.mixin.", "");
                    if (!requiredModPresent) {
                        this.mixinsMissingMods.put(mixinClassName, requiredModId);
                    } else if (isClientOnly && !ModernFixPlatformHooks.INSTANCE.isClient()) {
                        this.mixinsMissingMods.put(mixinClassName, "[not client]");
                    }
                    String mixinCategoryName = "mixin." + mixinClassName.substring(0, mixinClassName.lastIndexOf(46));
                    this.mixinOptions.add(mixinCategoryName);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                ModernFix.LOGGER.error("Error scanning file " + mixinPath, (Throwable)e);
            }
        }
    }

    private ModernFixEarlyConfig(File file) {
        this.configFile = file;
        OptionCategories.load();
        this.scanForAndBuildMixinOptions();
        this.mixinOptions.addAll((Collection<String>)DEFAULT_SETTING_OVERRIDES.keySet());
        for (String string : this.mixinOptions) {
            boolean defaultEnabled = (Boolean)DEFAULT_SETTING_OVERRIDES.getOrDefault((Object)string, (Object)true);
            Option option = new Option(string, defaultEnabled, false);
            this.options.putIfAbsent(string, option);
            this.optionsByCategory.put((Object)OptionCategories.getCategoryForOption(string), (Object)option);
        }
        for (Map.Entry entry : this.options.entrySet()) {
            String potentialParentKey;
            Option potentialParent;
            int idx = ((String)entry.getKey()).lastIndexOf(46);
            if (idx <= 0 || (potentialParent = this.options.get(potentialParentKey = ((String)entry.getKey()).substring(0, idx))) == null) continue;
            ((Option)entry.getValue()).setParent(potentialParent);
        }
        this.addMixinRule("launch.class_search_cache", true);
        this.disableIfModPresent("mixin.perf.thread_priorities", "smoothboot", "threadtweak");
        this.disableIfModPresent("mixin.perf.boost_worker_count", "smoothboot", "threadtweak");
        this.disableIfModPresent("mixin.perf.compress_biome_container", "chocolate", "betterendforge", "skyblockbuilder", "modern_beta");
        this.disableIfModPresent("mixin.bugfix.mc218112", "performant");
        this.disableIfModPresent("mixin.bugfix.remove_block_chunkloading", "performant");
        this.disableIfModPresent("mixin.bugfix.paper_chunk_patches", "c2me");
        this.disableIfModPresent("mixin.bugfix.preserve_early_window_pos", "better_loading_screen");
        this.disableIfModPresent("mixin.perf.cache_strongholds", "littletiles", "c2me");
        this.disableIfModPresent("mixin.perf.deduplicate_wall_shapes", "dashloader");
        this.disableIfModPresent("mixin.perf.nbt_memory_usage", "c2me");
        this.disableIfModPresent("mixin.bugfix.chunk_deadlock", "c2me", "dimthread");
        this.disableIfModPresent("mixin.perf.reuse_datapacks", "tac");
        this.disableIfModPresent("mixin.launch.class_search_cache", "optifine");
        this.disableIfModPresent("mixin.perf.faster_texture_stitching", "optifine");
        this.disableIfModPresent("mixin.perf.datapack_reload_exceptions", "cyanide");
        this.disableIfModPresent("mixin.perf.faster_texture_loading", "stitch", "optifine", "changed");
        if (isFabric) {
            this.disableIfModPresent("mixin.bugfix.packet_leak", "memoryleakfix");
        }
        this.checkBlockstateCacheRebuilds();
    }

    private void checkBlockstateCacheRebuilds() {
        if (!ModernFixPlatformHooks.INSTANCE.isDevEnv()) {
            return;
        }
        try {
            if (ModernFixEarlyConfig.class.getResource("/net/minecraft/world/level/Level.class") == null) {
                LOGGER.warn("We are in a non-Mojmap dev environment. Disabling blockstate cache patch");
                this.options.get("mixin.perf.reduce_blockstate_cache_rebuilds").addModOverride(false, "[not mojmap]");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void disableIfModPresent(String configName, String ... ids) {
        for (String id : ids) {
            Option option;
            if (ModernFixPlatformHooks.INSTANCE.isEarlyLoadingNormally() && !ModernFixEarlyConfig.modPresent(id) || (option = this.options.get(configName)) == null) continue;
            option.addModOverride(false, id);
        }
    }

    private void addMixinRule(String mixin, boolean enabled) {
        String name = ModernFixEarlyConfig.getMixinRuleName(mixin);
        if (this.options.putIfAbsent(name, new Option(name, enabled, false)) != null) {
            throw new IllegalStateException("Mixin rule already defined: " + mixin);
        }
    }

    private void readJVMProperties() {
        for (String optionKey : this.options.keySet()) {
            String value = System.getProperty("modernfix.config." + optionKey);
            if (value == null || value.length() == 0) continue;
            boolean isEnabled = Boolean.valueOf(value);
            ModernFixMixinPlugin.instance.logger.info("Configured {} to '{}' via JVM property.", (Object)optionKey, (Object)isEnabled);
            this.options.get(optionKey).setEnabled(isEnabled, true);
        }
    }

    private void readProperties(Properties props) {
        if (ALLOW_OVERRIDE_OVERRIDES) {
            LOGGER.fatal("JVM argument given to override mod overrides. Issues opened with this option present will be ignored unless they can be reproduced without.");
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                LOGGER.warn("No configuration key exists with name '{}', ignoring", (Object)key);
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                LOGGER.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", (Object)value, (Object)key);
                continue;
            }
            if (ALLOW_OVERRIDE_OVERRIDES || !option.isModDefined()) {
                option.setEnabled(enabled, true);
                continue;
            }
            LOGGER.warn("Option '{}' already disabled by a mod. Ignoring user configuration", (Object)key);
        }
    }

    public Option getEffectiveOptionForMixin(String mixinClassName) {
        int nextSplit;
        int lastSplit = 0;
        Option rule = null;
        while ((nextSplit = mixinClassName.indexOf(46, lastSplit)) != -1) {
            String key = ModernFixEarlyConfig.getMixinRuleName(mixinClassName.substring(0, nextSplit));
            Option candidate = this.options.get(key);
            if (candidate != null && !(rule = candidate).isEnabled()) {
                return rule;
            }
            lastSplit = nextSplit + 1;
        }
        return rule;
    }

    public static ModernFixEarlyConfig load(File file) {
        ModernFixEarlyConfig config = new ModernFixEarlyConfig(file);
        Properties props = new Properties();
        if (!Boolean.getBoolean("modernfix.ignoreConfigForTesting")) {
            if (file.exists()) {
                try (FileInputStream fin = new FileInputStream(file);){
                    props.load(fin);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not load config file", e);
                }
                config.readProperties(props);
            }
            try {
                config.save();
            }
            catch (IOException e) {
                LOGGER.warn("Could not write configuration file", (Throwable)e);
            }
            config.readJVMProperties();
        }
        return config;
    }

    public void save() throws IOException {
        File dir = this.configFile.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            Option option;
            writer.write("# This is the configuration file for ModernFix.\n");
            writer.write("# In general, prefer using the config screen to editing this file. It can be accessed\n");
            writer.write("# via the standard mod menu on your respective mod loader. Changes will, however,\n");
            writer.write("# require restarting the game to take effect.\n");
            writer.write("#\n");
            writer.write("# The following options can be enabled or disabled if there is a compatibility issue.\n");
            writer.write("# Add a line with your option name and =true or =false at the bottom of the file to enable\n");
            writer.write("# or disable a rule. For example:\n");
            writer.write("#   mixin.perf.dynamic_resources=true\n");
            writer.write("# Do not include the #. You may reset to defaults by deleting this file.\n");
            writer.write("#\n");
            writer.write("# Available options:\n");
            List keys = this.options.keySet().stream().filter(key -> !key.equals("mixin.core")).sorted().collect(Collectors.toList());
            for (String line : keys) {
                if (line.equals("mixin.core")) continue;
                option = this.options.get(line);
                String extraContext = "";
                if (option != null) {
                    if (!option.isUserDefined()) {
                        extraContext = "=" + option.isEnabled() + " # " + (option.isModDefined() ? "(overridden for mod compat)" : "(default)");
                    } else {
                        boolean defaultEnabled = (Boolean)DEFAULT_SETTING_OVERRIDES.getOrDefault((Object)line, (Object)true);
                        extraContext = "=" + defaultEnabled + " # (default)";
                    }
                }
                writer.write("#  " + line + extraContext + "\n");
            }
            writer.write("#\n");
            writer.write("# User overrides go here.\n");
            for (String key2 : keys) {
                option = this.options.get(key2);
                if (!option.isUserDefined()) continue;
                writer.write(key2 + "=" + option.isEnabled() + "\n");
            }
        }
    }

    private static String getMixinRuleName(String name) {
        return "mixin." + name;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public int getOptionOverrideCount() {
        return (int)this.options.values().stream().filter(Option::isOverridden).count();
    }

    public Map<String, Option> getOptionMap() {
        return Collections.unmodifiableMap(this.options);
    }

    public Multimap<String, Option> getOptionCategoryMap() {
        return Multimaps.unmodifiableMultimap(this.optionsByCategory);
    }

    static {
        boolean hasOfClass = false;
        try {
            Class.forName("optifine.OptiFineTransformationService");
            hasOfClass = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OPTIFINE_PRESENT = hasOfClass;
        MIXIN_DESC = Type.getDescriptor(Mixin.class);
        MIXIN_CLIENT_ONLY_DESC = Type.getDescriptor(ClientOnlyMixin.class);
        MIXIN_REQUIRES_MOD_DESC = Type.getDescriptor(RequiresMod.class);
        MIXIN_DEV_ONLY_DESC = Type.getDescriptor(IgnoreOutsideDev.class);
        PLATFORM_PREFIX = Pattern.compile("(forge|fabric|common)\\.");
        isFabric = ModernFixEarlyConfig.class.getClassLoader().getResourceAsStream("modernfix-fabric.mixins.json") != null;
        isDevEnv = ModernFixPlatformHooks.INSTANCE.isDevEnv();
        shouldReplaceSearchTrees = ModernFixEarlyConfig.modPresent("jei") && !ModernFixEarlyConfig.modPresent("roughlyenoughitems");
        DEFAULT_SETTING_OVERRIDES = new DefaultSettingMapBuilder().put("mixin.perf.dynamic_resources", false).putConditionally(() -> !isFabric, "mixin.perf.async_jei", false).put("mixin.perf.reuse_datapacks", false).put("mixin.perf.dynamic_block_codecs", false).put("mixin.feature.direct_stack_trace", false).putConditionally(ModernFixPlatformHooks.INSTANCE::isDevEnv, "mixin.perf.rewrite_registry", false).put("mixin.perf.clear_mixin_classinfo", false).put("mixin.bugfix.packet_leak", false).put("mixin.perf.deduplicate_location", false).put("mixin.feature.integrated_server_watchdog", true).put("mixin.perf.faster_item_rendering", false).put("mixin.feature.spam_thread_dump", false).put("mixin.feature.snapshot_easter_egg", true).put("mixin.feature.warn_missing_perf_mods", true).put("mixin.feature.spark_profile_launch", false).put("mixin.perf.blast_search_trees", shouldReplaceSearchTrees).put("mixin.devenv", isDevEnv).put("mixin.perf.remove_spawn_chunks", isDevEnv).putConditionally(() -> !isFabric, "mixin.bugfix.fix_config_crashes", true).putConditionally(() -> isFabric, "mixin.perf.clear_fabric_mapping_tables", false).build();
    }

    private static class DefaultSettingMapBuilder
    extends ImmutableMap.Builder<String, Boolean> {
        private DefaultSettingMapBuilder() {
        }

        public DefaultSettingMapBuilder putConditionally(BooleanSupplier condition, String k, Boolean v) {
            if (condition.getAsBoolean()) {
                this.put(k, v);
            }
            return this;
        }

        public DefaultSettingMapBuilder put(String key, Boolean value) {
            super.put((Object)key, (Object)value);
            return this;
        }
    }
}

