/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_block_codecs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={StateHolder.class})
public class StateHolderMixin {
    private static final LoadingCache<Block, MapCodec<BlockState>> MODERNFIX_CODEC_CACHE = CacheBuilder.newBuilder().maximumSize(100000L).build((CacheLoader)new CacheLoader<Block, MapCodec<BlockState>>(){

        public MapCodec<BlockState> load(Block block) throws Exception {
            Supplier<BlockState> stateSupplier = () -> ((Block)block).func_176223_P();
            MapCodec mapCodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(stateSupplier));
            for (Property property : block.func_176194_O().func_177623_d()) {
                mapCodec = StateContainer.func_241487_a_((MapCodec)mapCodec, stateSupplier, (String)property.func_177701_a(), (Property)property);
            }
            return mapCodec;
        }
    });

    @Redirect(method={"codec"}, at=@At(value="INVOKE", target="Lcom/mojang/serialization/Codec;dispatch(Ljava/lang/String;Ljava/util/function/Function;Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;", remap=false))
    private static <O, S extends StateHolder<O, S>> Codec<S> obtainCodec(Codec<O> codec, String typeKey, Function<S, O> type, Function<O, ? extends Codec<S>> codecFn, Codec<O> codecMethodArg, Function<O, S> stateSupplier) {
        return codec.dispatch(typeKey, type, block -> {
            if (block instanceof Block) {
                MapCodec mapCodec;
                StateHolder state = (StateHolder)stateSupplier.apply(block);
                if (state.func_206871_b().isEmpty()) {
                    return Codec.unit((Object)state);
                }
                try {
                    mapCodec = (MapCodec)MODERNFIX_CODEC_CACHE.get((Object)((Block)block));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                return mapCodec.fieldOf("Properties").codec();
            }
            return (Codec)codecFn.apply(block);
        });
    }
}

